<?php namespace Visiosoft\BookingModule\Booking\Listener;

use Anomaly\Streams\Platform\Entry\Event\EntryWasDeleted;
use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Booking\Events\CancellationBooking;

class NotifyCanceledBooking
{
    /**
     * @var Dispatcher
     */
    private $dispatcher;

    /**
     * NotifyCanceledBooking constructor.
     * @param Dispatcher $dispatcher
     */
    public function __construct(Dispatcher $dispatcher)
    {
        $this->dispatcher = $dispatcher;
    }

    /**
     * @param EntryWasDeleted $event
     */
    public function handle(EntryWasDeleted $event)
    {
        $entry = $event->getEntry();

        if ($entry->getBoundModelName() == BookingModel::class) {
            $this->dispatcher->dispatch(new CancellationBooking($entry->getId()));
        }
    }
}
