<?php namespace Visiosoft\BookingModule\Http\Controller\Admin;

use Anomaly\FilesModule\File\Form\EntryFormBuilder;
use Anomaly\Streams\Platform\Entry\EntryModel;
use function CoffeeScript\t;
use function foo\func;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Staff\Form\StaffFormBuilder;
use Visiosoft\BookingModule\Staff\StaffModel;
use Visiosoft\BookingModule\Staff\Table\StaffTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class StaffController extends AdminController
{
    private $model;
    private $service;

    public function __construct(StaffModel $staffModel, ServiceModel $serviceModel)
    {
        parent::__construct();
        $this->model = $staffModel;
        $this->service = $serviceModel;
    }

    /**
     * Display an index of existing entries.
     *
     * @param StaffTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(StaffTableBuilder $table)
    {
        $table->setColumns(['name', 'services' => [
            'value' => function (EntryModel $entry) {
                $value = "";
                foreach ($entry->services as $item) {
                    $service = $this->service->newQuery()->find($item);
                    $value .= $service ? $service->name . ',' : '';
                }
                return $value;
            }
        ]]);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param StaffFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(StaffFormBuilder $form)
    {
        $form->setFields([
            'photo', 'name', 'description',
            'mondayStart',
            'mondayEnd',
            'tuesdayStart',
            'tuesdayEnd',
            'wednesdayStart',
            'wednesdayEnd',
            'thursdayStart',
            'thursdayEnd',
            'fridayStart',
            'fridayEnd',
            'saturdayStart',
            'saturdayEnd',
            'sundayStart',
            'sundayEnd',
            'mondayStartNoon',
            'mondayEndNoon',
            'tuesdayStartNoon',
            'tuesdayEndNoon',
            'wednesdayStartNoon',
            'wednesdayEndNoon',
            'thursdayStartNoon',
            'thursdayEndNoon',
            'fridayStartNoon',
            'fridayEndNoon',
            'saturdayStartNoon',
            'saturdayEndNoon',
            'sundayStartNoon',
            'sundayEndNoon',
            'services' => [
                'type' => 'anomaly.field_type.checkboxes',
                'config' => [
                    'options' => function (ServiceModel $serviceModel) {
                        $services = $serviceModel->get()->pluck('name', 'id')->all();
                        $services = $this->addServiceLocation($services);
                        return $services;
                    }
                ],
            ],
            'enabled',
        ]);
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param StaffFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(StaffFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @param $id
     * @return mixed
     */
    public function getServiceName($id)
    {
        return $this->service->getServiceName($id);
    }

    public function getStaff($service_id)
    {
        return $this->model->getServiceStaff($service_id);
    }

    public function addServiceLocation(array $services)
    {
        foreach ($services as $index => $service) {
            $services[$index] = $services[$index] . " (" . $this->service->getServices($index)->location->name . ")";
        }
        return $services;
    }
}
