<?php namespace Visiosoft\BookingModule\Booking\Table\Filter;

use Anomaly\Streams\Platform\Ui\Table\Component\Filter\Contract\FilterInterface;
use Anomaly\Streams\Platform\Ui\Table\Component\Filter\Query\GenericFilterQuery;
use Illuminate\Contracts\Container\Container;
use Illuminate\Database\Eloquent\Builder;
use Visiosoft\BookingModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\BookingModule\Service\Contract\ServiceRepositoryInterface;

/**
 * Class LocationFilterQuery
 *
 * @author        Dia Shalabi <dia@visisoft.com.tr>
 */
class LocationFilterQuery extends GenericFilterQuery
{

    private $locationRepository;
    private $serviceRepository;

    public function __construct(
        Container $container,
        LocationRepositoryInterface $locationRepository,
        ServiceRepositoryInterface $serviceRepository
    )
    {
        parent::__construct($container);

        $this->locationRepository = $locationRepository;
        $this->serviceRepository = $serviceRepository;
    }

    /**
     * Handle the filter query.
     *
     * @param Builder         $query
     * @param FilterInterface $filter
     */
    public function handle(Builder $query, FilterInterface $filter)
    {
        $services = $this->serviceRepository->newQuery()
            ->where('location_id', $filter->getValue())->pluck('id');

        $query->whereIn('services_select', $services);
    }
}
