<?php namespace Visiosoft\BookingModule\Booking\Table\Component\View\Type;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;


class Table extends View
{


    protected $slug = 'table';


    protected $text = 'visiosoft.module.booking::view.table';


    protected $icon = 'fa fa-list-ul';


    protected $columns = [
        'staff',
        'booking_datetime_start',
        'name',
        'phone',
        'email',
        'service' => [
            'heading' =>'visiosoft.module.booking::field.services_select.name',
            'value' =>
                '{{ findService(entry.services_select).name }} '
        ],
        'services_select' => [
            'heading' =>'visiosoft.module.booking::field.gift.name',
            'value' =>
                '{% if findService(entry.services_select).gift == true %} ' .
                '<i  class="fa fa-check text-success"></i>' .
                ' {% endif %}',
        ],
    ];


    protected $buttons = [
    ];


    public $assets = [];


    public $options = [
        'order_by' => [
            'id' => 'DESC'
        ]
    ];


    protected $query = AllQuery::class;

    public function onQuerying(MessageBag $messageBag)
    {
        $messageBag->info([trans("visiosoft.module.booking::messages.edit_message")]);
    }

}
