<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;
use Visiosoft\BookingModule\Service\Services;

class VisiosoftModuleBookingCreateBookingFields extends Migration
{

    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'name' => 'anomaly.field_type.text',
        'color' => 'anomaly.field_type.colorpicker',
        'description' => 'anomaly.field_type.text',
        'email' => 'anomaly.field_type.email',
        'address' => 'anomaly.field_type.text',
        'phone' => 'anomaly.field_type.text',
        "time" => [
            "type" => "anomaly.field_type.integer",
            "config" => [
                "step" => 5,
                "max" => 300,
                "min" => 5,
            ]
        ],
        'price' => 'anomaly.field_type.decimal',
        'location' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                "mode" => "search",
                'related' => \Visiosoft\BookingModule\Location\LocationModel::class,
            ],
        ],
        'photo' => [
            'type' => 'anomaly.field_type.file',
            'config' => [
                'folders' => ["images"],
                'mode' => 'upload',
            ]
        ],
        "services" => [
            'type' => 'anomaly.field_type.checkboxes',
            "config" => [
                "handler" => Visiosoft\BookingModule\Service\Services::class,
                'min' => 1,
            ]
        ],
        "services_select" => [
            'type' => 'anomaly.field_type.select',
            "config" => [
                "handler" => Visiosoft\BookingModule\Service\ServicesSelect::class,
                'min' => 1,
                'mode' => 'buttons'
            ]
        ],
        'staff' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Visiosoft\BookingModule\Staff\StaffModel::class,
            ],
        ],
        'user' => [
            'type' => 'anomaly.field_type.relationship',
            'config' => [
                'related' => \Anomaly\UsersModule\User\UserModel::class,
            ],
        ],
        "total_price" => 'anomaly.field_type.decimal',
        "booking_datetime_start" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default" => 'now',
                "mode" => "datetime",
                "picker" => true,
            ]
        ],
        "booking_datetime_end" => [
            "type" => "anomaly.field_type.datetime",
        ],
        "payment_type" => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => ["paypal" => "PayPal", "cash" => "Cash"],
                "separator" => ":",
                "default_value" => 'cash',
                "mode" => "buttons",
            ]
        ],
        "payment_status" => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => ["success" => "Success", 'waiting' => 'Waiting Payment', 'failed' => 'Failed Payment'],
                "separator" => ":",
                "default_value" => 'waiting',
                "mode" => "buttons",
            ]
        ],
        "status" => [
            "type" => "anomaly.field_type.select",
            "config" => [
                "options" => ["active" => "Active", 'cancelled' => 'Cancelled', 'pending' => 'Pending Activation Number'],
                "separator" => ":",
                "default_value" => 'pending',
                "mode" => "buttons",
            ]
        ],
        "mondayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "mondayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "tuesdayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "tuesdayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "wednesdayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "wednesdayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "thursdayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "thursdayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "fridayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "fridayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "saturdayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "saturdayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "sundayStart" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "sundayEnd" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        'activation_code' => [
            'type' => 'anomaly.field_type.integer',
        ],
        'activated' => [
            'type' => 'anomaly.field_type.integer',
            'config' => [
                'default_value' => 0,
            ]
        ],
        "mondayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "mondayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "tuesdayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "tuesdayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "wednesdayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "wednesdayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "thursdayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "thursdayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "fridayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "fridayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "saturdayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "saturdayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "sundayStartNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        "sundayEndNoon" => [
            "type" => "anomaly.field_type.datetime",
            "config" => [
                "default_value" => "00:00:00",
                "mode" => "time",
                "time_format" => "H:i",
                "picker" => true,
                "step" => 5,
            ]
        ],
        'enabled' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => true,
            ],
        ],
        'gift' => [
            'type' => 'anomaly.field_type.boolean',
            'config' => [
                'default_value' => false,
            ],
        ],
        "date" => [
            "type"   => "anomaly.field_type.datetime",
            "config" => [
                "mode"          => "date",
                "date_format"   => "j F, Y",
                "picker"        => true,
            ]
        ]
    ];

}
