<?php namespace Visiosoft\BookingModule\Staff;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use DatePeriod;
use DateTime;
use function GuzzleHttp\Psr7\str;
use stdClass;
use Visiosoft\BookingModule\Staff\Contract\StaffInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingStaffEntryModel;

class StaffModel extends BookingStaffEntryModel implements StaffInterface
{
    public function getStaff($id = null)
    {
        if ($id == null) return $this->get();
        return $this->find($id);
    }

    public function addFotoStaff(array $items)
    {
        foreach ($items as $key => $item) {
            $items[$key]['photo_url'] = $this->getPhoto($item['id']);
        }
        return $items;
    }

    public function getPhoto($staff_id)
    {
        $staff = $this->find($staff_id)->photo;
        if ($staff != null) {
            return url('files/images/' . $this->find($staff_id)->photo->name);
        }
        return $this->dispatch(new MakeImageInstance('visiosoft.module.booking::img/no-profile.png', 'img'))->url();
    }

    public function getServiceStaff($service_id)
    {
        return $this->whereRaw('services REGEXP \'.*;s:[0-9]+:"' . $service_id . '".*\'')->get();
    }


    public function diffMinutes($to, $from)
    {
        $to_time = strtotime($to);
        $from_time = strtotime($from);
        return round(abs($to_time - $from_time) / 60, 2);
    }

    public function addMinutesTimes(array $closed_for_start = [], $minutes, $part, $current_time)
    {
        $q = $minutes / $part;

        if ($q > 0)
            $closed_for_start[] = $current_time;

        if ($q > 1) {
            for ($i = 1; $i < $q; $i++) {
                $time = new \DateTime($current_time);
                $time->add(new \DateInterval('PT' . $part * $i . 'M'));

                $stamp = $time->format('Y-m-d H:i:s');
                $closed_for_start[] = $stamp;
            }
        }

        return $closed_for_start;
    }

    public function getBookingDate($start_week)
    {
        $bokingDayLimit = setting_value('visiosoft.module.booking::bookingDateLimit') + 1;

        $end_week = date('Y-m-d H:i:s', strtotime($start_week . ' + ' . $bokingDayLimit . ' day'));

        $week = new DatePeriod(
            new \DateTime($start_week),
            new \DateInterval('P1D'),
            new \DateTime($end_week)
        );

        return $week;
    }

    public function addJobTime($staff)
    {
        if ($staff == 0) {
            $staff_list = $this->where('enabled',1)->get();
            $staff_jobs = array();
            foreach ($staff_list as $staff) {
                $staff_jobs[$staff->id] = $this->getStaffByid($staff->id);
            }
        } else {
            $staff_jobs = $this->getStaffByid($staff);
        }
        return $staff_jobs;
    }

    public function getStaffByid($staffid) {
        return $this->select("mondayStart", "mondayEnd", "tuesdayStart", "tuesdayEnd",
                            "wednesdayStart", "wednesdayEnd", "thursdayStart", "thursdayEnd",
                            "fridayStart", "fridayEnd", "saturdayStart", "saturdayEnd", "sundayStart", "sundayEnd",
                            "mondayStartNoon", "mondayEndNoon", "tuesdayStartNoon", "tuesdayEndNoon",
                            "wednesdayStartNoon", "wednesdayEndNoon", "thursdayStartNoon", "thursdayEndNoon",
                            "fridayStartNoon", "fridayEndNoon", "saturdayStartNoon", "saturdayEndNoon",
                            "sundayStartNoon", "sundayEndNoon")
            ->find($staffid)->toArray();
    }
    public function getStaffForNonListWithDate($list, $date)
    {
        $dayName = strtolower(date("l", strtotime($date)));
        $time = strtolower(date("H:i:s", strtotime($date)));

        return $this->newQuery()
            ->where('enabled', true)
            ->whereNotIn('id', $list)
            ->whereTime($dayName . 'Start', '<', "$time")
            ->whereTime($dayName . 'End', '>', "$time")
            ->where(function ($query) use ($dayName, $time) {
                $query
                    ->whereTime($dayName . 'StartNoon', '>', "$time")
                    ->orWhereTime($dayName . 'EndNoon', '<', "$time");
            })
            ->inRandomOrder()
            ->first();
    }
}
