<?php namespace Visiosoft\BookingModule\Booking\Events;

use Hashids\Hashids;
use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Staff\StaffModel;

class ActivationBooking
{
    public $booking_id;

    /**
     * CreateBooking constructor.
     * @param $booking_id
     */
    public function __construct($booking_id)
    {
        $this->booking_id = $booking_id;
    }

    public function detail()
    {
        //Get Booking Detail
        $booking_model = new BookingModel();
        $booking = $booking_model->find($this->booking_id);
        return $booking;
    }

    public function getHashID()
    {
        $hashIds = new Hashids('V1si@b00k1ng', 5);
        return $hashIds->encode($this->detail()->id, $this->detail()->activation_code);
    }

    public function service()
    {
        //Get Service Detail
        $service_model = new ServiceModel();
        $service = $service_model->getServices($this->detail()->services_select);
        return $service;
    }

    public function location()
    {
        //Get Location Detail
        $location_model = new LocationModel();
        $location = $location_model->getLocations($this->service()->location_id);
        return $location;
    }

    public function staff()
    {
        //Get Staff Detail
        $staff_model = new StaffModel();
        $staff = $staff_model->getStaff($this->detail()->staff_id);
        return $staff;
    }
}
