var dateList = [];
var timeList = [];
var date = [];
var holidays = [];
var SelectedDate;
var ServiceTime = 20;
var staffData = [];
var bookingData = [];
var days = ['sunday', 'monday', 'tuesday', 'wednesday', 'thursday', 'friday', 'saturday'];

$(document).ready(function () {

    phoneMask("input[name='phone']")


    var navListItems = $('div.setup-panel div a'),
        allWells = $('.setup-content'),
        parameters = {};

    allWells.hide();

    navListItems.click(function (e) {
        e.preventDefault();
        var $target = $($(this).attr('href')),
            $item = $(this);

        if (!$item.hasClass('disabled')) {
            navListItems.removeClass('btn-success').addClass('btn-default');
            $item.addClass('btn-success');
            allWells.hide();
            $target.show();
            $target.find('input:eq(0)').focus();
        }
    });

    $(document).on('click', '.instant-next', function () {
        var curStep = $(this).closest(".setup-content"),
            curStepBtn = curStep.attr("id"),
            skipStep = null,
            nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
            curInputs = curStep.find("input[type='text'],input[type='url'],input[type='radio']"),
            isValid = true;

        $(".form-group").removeClass("has-error");

        for (var i = 0; i < curInputs.length; i++) {
            if (!curInputs[i].validity.valid) {
                isValid = false;
                $(curInputs[i]).closest(".form-group").addClass("has-error");
            }
        }
        var btn = $(this).closest(".panel-body").children("input"),
            ItemType = btn.attr('name'),
            CheckedItem = $("input[name='" + ItemType + "_input']:checked"),
            Value = CheckedItem.val(),
            ItemText = CheckedItem.parent().find('label').text();

        parameters[ItemType] = Value;

        if (btn.hasClass('send')) {
            if (isValid) renderData(ItemType, Value, true);
        }

        if (btn.hasClass('getBooking')) {
            if (isValid) renderData(ItemType, JSON.stringify(parameters), true);
        }

        if (isValid) {
            if (ItemType == "service") {
                selectedService(Value, function (callback) {
                    skipStep = callback;
                })
            }
            $('input[name="' + ItemType + '_id"]').val(Value);
            createBreadCrumb(ItemText, curStepBtn);
            if (skipStep != null) {
                nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().next().children("a");
            }
            nextStepWizard.removeAttr('disabled').trigger('click');
        }

    });

    function locationsRedirect(curStep, body_content, id) {
        curStep = $(curStep);
        var curStepBtn = curStep.attr("id"),
            nextStepWizard = $('div.setup-panel div a[href="#' + curStepBtn + '"]').parent().next().children("a"),
            isValid = true;

        $(".form-group").removeClass("has-error");

        var btn = $(body_content).children("input"),
            ItemType = btn.attr('name'),
            CheckedItem = $(`input[value='${id}']`),
            Value = CheckedItem.val(),
            ItemText = CheckedItem.parent().find('label').text();

        parameters[ItemType] = Value;

        if (btn.hasClass('send')) {
            if (isValid) renderData(ItemType, Value, false);
        }

        $('input[name="' + ItemType + '_id"]').val(Value);
        createBreadCrumb(ItemText, curStepBtn);
        nextStepWizard.removeAttr('disabled').trigger('click');
    }

    if (locationId) {
        locationsRedirect('#step-1', '.body_location', locationId);
    }

    $('div.setup-panel div a.btn-success').trigger('click');
});

function createBreadCrumb(value, step) {
    if ($(".breadcrumb-" + step).length == 0) {
        $('.booking-breadcrumb').html($('.booking-breadcrumb').html() + '<li class="booking-breadcrumb-active breadcrumb-' + step + '" data-step="' + step + '"><a>' + value + '</a></li>');
    } else {
        $(".breadcrumb-" + step + " a").html(value);
    }
}

function createInput(id, name, type, photo = "") {
    var input = "";
    if (type == "staff") input += '<label style="cursor: pointer" for="' + type + id + '"><div class=\'col-xs-12 row staff-container\'>' +
        '<div class="col-xs-4 no-padding img-mobile-book" style="min-height: unset !important; "><img class="staff-img" src="' + photo + '"/></div>' +
        '<div class="col-xs-8 no-padding pull-right checkbox-mobile-book" style="min-height: unset !important;">';

    input += '<div class="funkyradio" style="height: 100%">\n<div style="height: 100%;display: flex;align-items: center" class="funkyradio-warning">\n' +
        '<input class="instant-next" type="radio" id="' + type + id + '" name="' + type + '_input"\n required value="' + id + '"/>\n' +
        '<label for="' + type + id + '">' + name + '</label>\n' +
        '</div>\n</div>';
    if (type == "staff") input += '</div></div></label>';

    return input
}

function renderData(name, val, async) {
    sendData(name, val, async, function (response) {
        if (response.type != undefined) {
            responseInput(response);
        } else {
            dateList = [];
            timeList = [];
            date = [];
            SelectedDate = "";
            ServiceTime = 20;
            holidays = response.holidays
            createDate(response)
            var CloseTime = [];
            var dt = moment.utc();
            SelectedDate = dt.format("YYYY-MM-DD");
            var day_name = dt.locale('en').format('ddd');
            ServiceTime = response.service.service_time;

            if (countObj(response.location) > 0) {
                timeList = response['location'].Days;
                CloseTime = timeList[day_name];
            }

            if (countObj(response.staff) > 0) {
                staffData = response.staff;
            }
            if (countObj(response.booking) > 0) {
                bookingData = response.booking;
            }
            if (CloseTime != undefined && holidayCheck(SelectedDate) == false) {
                createTime('#timeSelect', CloseTime, day_name, SelectedDate);
            } else {
                $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                    '<h4 class="alert-heading">' +
                    '<i class="fa fa-exclamation-triangle"></i>' +
                    close_day_msg +
                    '</h4>\n' +
                    '</div>');
            }
        }

    })
}

function sendData(name, val, async, callback) {
    $.ajax({
        type: "GET",
        async: async,
        data: 'name=' + name + '&val=' + val,
        url: "/srv/" + name,
        success: function (response) {
            callback(response);
        },

    });
}

function responseInput(response) {
    $('.body_' + response.type + ' .input').html("");
    var photo_url;
    $.each(response.items, function (key, value) {
        if (value.photo_url != undefined) photo_url = value.photo_url;
        if (response.type == "service") value.name = value.name + " - " + value.price + currency;
        $('.body_' + response.type + ' .input').html($('.body_' + response.type + ' .input').html() +
            createInput(value.id, value.name, response.type, photo_url))
    });
}

function createDate(date) {
    var CloseDays;
    if (date.length > 0) {
        CloseDays = date[0].Days.closeDays.toString();
    }

    $('#paginator-start-end').datepaginator({
         startDate: formatDate(new Date()),
        itemWidth: 200,
        selectedItemWidth: 200,
        offDays: CloseDays,
        endDate: formatDate(moment().add(bookingDateLimit, 'days')),
    });

    $('#paginator-start-end').on('selectedDateChanged', function (event, date) {
        var dt = moment(date, "YYYY-MM-DD");
        SelectedDate = dt.format("YYYY-MM-DD");
        var day_name = dt.locale('en').format('ddd');
        if (countObj(timeList) > 0 && timeList[day_name] != undefined && holidayCheck(SelectedDate) === false) {
            createTime('#timeSelect', timeList[day_name], day_name, SelectedDate);
        } else {
            $('#timeSelect').html('<div class="alert alert-default alert-time" role="alert">\n' +
                '<h4 class="alert-heading">' +
                '<i class="fa fa-exclamation-triangle"></i>' +
                close_day_msg +
                '</h4>\n' +
                '</div>');
        }
    });
}

function holidayCheck(selectedDate) {
    var b = holidays.filter(item => item.date.toLowerCase().indexOf(selectedDate) > -1);
    if (countObj(b) > 0) {
        return true
    }
    return false
}

function dateParse(time) {
    return moment.utc(SelectedDate + " " + time + ":00", 'YYYY-MM-DD HH:mm:ss');
}

function createTime(selector, time, day_name, selectedDate) {
    if (time != undefined) {
        var select = $(selector);
        var startTime = 600;
        var endTime = 1080;
        if (countObj(time) > 0) startTime = createTimeStartEndFormat(time['start']);
        if (countObj(time) > 0) endTime = createTimeStartEndFormat(time['end']);
        select.html("");
        var hours, minutes, staffTodayStart, stafftodayEnd, staffTodayStartNoon, stafftodayEndNoon,
            timeAvaliableForStaffNoon, timeAvaliableForStaff, timeAvaliableForBooking;

        var curDate = moment.utc(SelectedDate);
        var dayNameArr = days[curDate.format('d')];

        // Staff working hours
        staffTodayStart = dateParse(staffData[dayNameArr + "Start"]);
        stafftodayEnd = dateParse(staffData[dayNameArr + "End"]);

        // Noon break for staff
        staffTodayStartNoon = dateParse(staffData[dayNameArr + "StartNoon"]);
        stafftodayEndNoon = dateParse(staffData[dayNameArr + "EndNoon"]);

        for (var i = startTime; i < endTime; i += ServiceTime) {
            hours = Math.floor(i / 60);
            minutes = i % 60;
            if (minutes < 10) {
                minutes = '0' + minutes;
            }
            if (hours < 10) {
                hours = '0' + hours;
            }
            var time = hours + ':' + minutes;
            var selectedDateTime = dateParse(time);

            // Check if any noon hours for staff
            timeAvaliableForStaffNoon = 0;  // staff not available for this time period.
            // console.log(staffTodayStartNoon.format('x'),staffTodayStartNoon)
            if (staffTodayStartNoon.format('x') <= selectedDateTime.format('x') && stafftodayEndNoon.format('x') > selectedDateTime.format('x')) {
                timeAvaliableForStaffNoon = 1; // staff available for this time period.
            }
            // check if staff is working or not?
            timeAvaliableForStaff = 0;  // staff not available for this time period.
            if (staffTodayStart.format('x') <= selectedDateTime.format('x') && stafftodayEnd.format('x') > selectedDateTime.format('x')) {
                timeAvaliableForStaff = 1; // staff available for this time period.
            }

            var timeAvaliableForBooking = 0;

            $.each(bookingData, function (index, value) {
                var dateTimeCurrentSlot = dateParse(time);

                const booking_datetime_start = moment.utc(value.booking_datetime_start),
                    booking_datetime_end = moment.utc(value.booking_datetime_end),

                    geriyegit = booking_datetime_start.subtract(ServiceTime - 1, "minutes"),
                    baslangic = booking_datetime_start.subtract(1, "minutes"),
                    backwardTime = moment(dateTimeCurrentSlot).isBetween(geriyegit, booking_datetime_start),
                    forwardTime = moment(dateTimeCurrentSlot).isBetween(baslangic, booking_datetime_end)

                if (backwardTime || forwardTime) {
                    timeAvaliableForBooking = 1;
                }

            });

            var disabled = '';
            if (!timeAvaliableForStaff || timeAvaliableForStaffNoon || timeAvaliableForBooking) {
                disabled = 'disabled';
            }
            select.append(createTimeInput('time', time, disabled));
        }
    }
}

function createTimeInput(type, name, disabled) {
    var input = '<button class="btn btn-default btn-time" name="time"\n' +
        disabled + ' required type="button" onclick="selectedTime(this)">\n' +
        name + '</button>';

    return input;

}

function formatDate(date) {
    var m = moment.utc(date),
        month1 = '' + (m.format('M')),
        day1 = '' + m.format('DD'),
        year1 = parseInt(m.format('YYYY'));

    if (month1.length < 2) month1 = '0' + month1;
    if (day1.length < 2) day1 = '0' + day1;

    return [year1, month1, day1].join('-');
}

function createTimeStartEndFormat(time) {
    time = time.split(':');
    return parseInt(time[0]) * 60 + parseInt(time[1])
}


function selectedTime(element) {
    $('.btn-time').removeClass('selected-Time');
    $(element).addClass('selected-Time');
    var DateTime = $.trim(SelectedDate) + " " + $.trim($(element).html());
    createBreadCrumb(DateTime, 5)
    $('input[name="select_time"]').val(DateTime);
}

$('#booking-form').submit(function (e) {
    if ($('input[name="select_time"]').val() == "") {
        e.preventDefault();
        $('.time-validation-message').css('display', 'block');
    }
});


function countObj(x) {
    var that = x,
        count = 0;
    for (property in that) {
        if (that.hasOwnProperty(property)) {
            count++;
        }
    }
    return count;
}


function crud(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        async: false,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}


function selectedService(service, back) {
    crud('', '/ajax/getService/' + service, 'POST', function (callback) {
        if (callback.data != null && callback.data.gift == true) {
            $('.dateSelector, #timeSelect').addClass('hidden');
            $('input[name="select_time"]').val("0000-00-00 00:00")
            $('input[name="staff_id"]').val("null")
            back("skipStaff");
        }
    })
}