var start_date = null;
var end_date = null;
var refresh = true;
var refresh_time = 30000; // Millisecond
/***************************/
/***///      AJAX      ****/
/*************************/
function crudForBooking(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Edit Booking   ****/
/*************************/
function bookingModal(id) {
    crudForBooking('id=' + id, '/admin/booking/getDetail/' + id, 'GET', function (response) {
        var details = response; //Detail Booking

        var form = $('form[name="booking-modal-form"]');

        form.trigger("reset");

        //Get ALL Locations
        getLocations(function () {

            //Get Location ID With Service ID && Select Location
            getServiceLocation(details.services_select, function (response) {
                $('select[name="locations"]').val(response.location_id);
                //Get Services With Location ID && Select Service
                getServices(response.location_id, function (e) {
                    $('select[name="services_select"]').val(details.services_select);
                    //Get Staff With Service && Select Staff
                    getStaff(details.services_select, function (e) {

                        $("#payment_type > option[value='paypal']").attr('disabled', true);

                        if ($('input[name="id"]').length > 0) {
                            $('input[name="id"]').remove();
                        }

                        $('form[name="booking-modal-form"]').append('<input name="id" type="hidden" value="' + details.id + '">');

                        $('form[name="booking-modal-form"]').attr('data-type', 'edit');
                        $('select[name="staff"]').val(details.staff_id)
                        $('input[name="phone"]').val(details.phone);
                        $('input[name="email"]').val(details.email);
                        $('input[name="name"]').val(details.name);
                        $('input[name="total_price"]').val(details.total_price);
                        $('select[name="payment_type"]').val(details.payment_type);

                        //type is paypal
                        if (details.payment_type == "paypal") {
                            $('#payment_type ,input[name="email"],input[name="total_price"] ').attr('disabled', true);
                        } else {
                            $('#payment_type, input[name="email"], input[name="total_price').attr('disabled', false);
                        }

                        var removeBtn = $('.removeBtn');
                        removeBtn.attr('href', '/admin/booking/ajax/delete/' + details.id)


                        $('.payment_status').removeClass('hidden').find('font').html(payment_status[details.payment_status]);
                        if (details.payment_status != "success") {
                            $('.approvePayment').removeClass('hidden').attr('data-id', details.id);
                        }
                        if (details.status == "pending") {
                            $('.approveBtn').removeClass("hidden");
                            $('.approveMessage').removeClass("hidden");
                            var approveBtn = $('.approveBtn');
                            approveBtn.attr('data-id', details.id)
                        } else {
                            $('.approveBtn').addClass("hidden");
                            $('.approvePayment').addClass("hidden");
                            $('.approveMessage').addClass("hidden");
                        }
                        enable_picker(details.booking_datetime_start, details.booking_datetime_end);

                        $('.booking-edit-ajax').prop('disabled', false).removeClass('disabled')
                    })

                })

            });

        });

    });
    openModal();

}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Locations  ****/
/*************************/
function getLocations(callback) {
    crudForBooking('', '/admin/booking/ajax/locations', 'GET', function (response) {
        $('select[name="locations"]').html('');
        $.each(response, function (index, value) {
            const selected = index === 0 ? 'selected' : '';
            $('select[name="locations"]').append(`<option ${selected} value='${value.id}'>${value.name}</option>`);
        });
        return callback();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Location   ****/
/***/// With Service  ****/
/************************/
function getServiceLocation(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/find-services/booking_services.id,' + service_id, 'GET',
        function (response) {
            return callback(response);
        })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Services   ****/
/*************************/
function getServices(location_id, callback) {
    crudForBooking('', '/admin/booking/ajax/services/' + location_id, 'GET', function (response) {
        $('select[name="services_select"]').html('');
        $('select[name="services_select"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            // if (index == 0) getStaff(value.id);
            $('select[name="services_select"]').append(`
                <option value='${value.id}' data-price="${value.price}" data-time="${value.time}">
                    ${value.name}
                </option>
            `);
        });
        $('.services_select-field').show();
        $('.staff-field').hide();
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Staff      ****/
/*************************/
function getStaff(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/staff/' + service_id, 'GET', function (response) {
        $('select[name="staff"]').html('');
        $('select[name="staff"]').append('<option disabled>...</option>');
        $.each(response, function (index, value) {
            let selected = '';
            if (userId == value.user_id) {
                selected = 'selected'
            }
            $('select[name="staff"]').append(`<option ${selected} value='${value.id}'>${value.name}</option>`);
        });
        $('.staff-field').show();
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// On Change Start ****/
/**************************/
$('select[name="locations"]').on('change', function () {
    getServices($(this).val(), function () {
    })
})

$('select[name="services_select"]').on('change', function () {
    const selectedOption = $("option:selected", this);

    // Auto set end time
    const time = selectedOption.data('time');
    const finishDateInput = $('input[name=booking_datetime_end]');
    let finishDate = finishDateInput.val()
    finishDate = moment(new Date(finishDate)).add(time, 'm').toDate();
    const hiddenFinishDate = moment(finishDate).format('YYYY-MM-DD HH:mm');
    const formattedFinishDate = moment(finishDate).format('D MMMM, YYYY HH:mm');
    finishDateInput.val(hiddenFinishDate).siblings('input').val(formattedFinishDate)

    // Auto set price
    const price = selectedOption.data('price');
    $('input[name=total_price]').val(price)

    getStaff($(this).val(), function () {})
})
/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// Create Booking  ****/
/**************************/
function addBooking(date) {
    getLocations(function () {
        // Auto get services
        getServices($('select[name=locations]').val(), function () {})

        enable_picker(date, date);

        if ($('input[name="id"]').length > 0) {
            $('input[name="id"]').remove();
        }
        $('#payment_type, input[name="email"], input[name="total_price').attr('disabled', false);

        $('form[name="booking-modal-form"]').attr('data-type', 'create');
        $('select[name="services_select"]').html("");
        $('.payment_status').addClass('hidden').find('font').html('');
        $('.approvePayment').addClass('hidden').attr('href', '#');
        $('select[name="staff"]').html("");
        $('input[name="phone"]').val("");
        $('input[name="email"]').val("");
        $('input[name="name"]').val("");
        $('input[name="total_price"]').val("");
        $('.payment_type-field').hide().find('select[name="payment_type"]').val('cash').prop('disabled', true);
        $('.booking-edit-ajax').prop('disabled', false).removeClass('disabled');

        $('.approveBtn').addClass("hidden");
        $('.approvePayment').addClass("hidden");
        $('.approveMessage').addClass("hidden");

        openModal();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Create DatePicker****/
/**************************/
function enable_picker(start, end) {
    var opt = {
        altInput: true,
        allowInput: false,
        locale: "en",
        altFormat: "j F, Y H:i",
        minuteIncrement: 1,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        enableTime: true,
        noCalendar: false
    };
    if (start_date != null) {
        start_date.setDate(start);
    } else {
        $('input[name="booking_datetime_start"]').val(start);
        start_date = $('input[name="booking_datetime_start"]').flatpickr(opt);
    }
    if (end_date != null) {
        end_date.setDate(end);
    } else {
        $('input[name="booking_datetime_end"]').val(end)
        end_date = $('input[name="booking_datetime_end"]').flatpickr(opt);
    }
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Modal Form Submit****/
/**************************/
$('form[name="booking-modal-form"]').on("submit", function (event) {
    event.preventDefault();
    saveBooking($(this).serialize(), $('form[name="booking-modal-form"]').attr('data-type'))
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Save Booking  ****/
/**************************/
function saveBooking(params, type) {
    crudForBooking(params, '/admin/booking/ajax/' + type, 'POST', function (response) {

        $('#calendar').fullCalendar('refetchEvents');

        if (response.form == 'hide') {
            $('#bookingModal').modal('hide');
        }

        swal(form_status[response.status]);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Open Modal    ****/
/**************************/
function openModal() {
    $('#bookingModal').modal('show');
    refresh = false
    console.log("Refresh Stop!")
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///  On Modal Close    ****/
/**************************/
$('#bookingModal').on('hidden.bs.modal', function (e) {
    $('.booking-edit-ajax').prop('disabled', true).addClass('disabled')
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Refresh Function ****/
/**************************/

window.setInterval(function () {
    $('#calendar').fullCalendar('refetchEvents');
}, refresh_time);

/***********************************************************************************************************/
/**********************************************************************************************************/

$(function () {
    $('.services_select-field').hide();
    $('.staff-field').hide();
    $('#calendar').fullCalendar({
        events: `/admin/bookingJSON${window.location.search}`,
        timezone: "local",
        defaultView: 'agendaDay',
        editable: true,
        selectable: true,
        eventLimit: true, // allow "more" link when too many events
        header: {
            left: 'prev,next today',
            center: 'title',
            right: 'month,agendaWeek,agendaDay'
        },

        minTime: "07:00:00",

        allDaySlot: false,
        resources: '/admin/staffJSON',
        eventClick: function (event, element) {
            bookingModal(event.id);
        },
        dayClick: function (date, jsEvent, view, resource) {
            addBooking(moment(date._d).format('YYYY-MM-DD HH:mm'));
        }
    });

});


/***********************************************************************************************************/

/**********************************************************************************************************/


$('.approvePayment').on('click', function () {
    var id = $(this).data('id');
    crudForBooking('', '/admin/booking/ajax/approvePayment/' + id, 'GET', function (callback) {
        if (callback.status === true) {
            swal(approvedPaymentMsg);
            $('.payment_status').find('font').html(payment_status["success"]);
            $('.approvePayment').addClass('hidden');
        }
    });
});


$('.approveBtn').on('click', function () {
    var id = $(this).data('id');
    crudForBooking('', '/admin/booking/ajax/approve/' + id, 'GET', function (callback) {
        if (callback.status === true) {
            swal(approvedBooking);
            $('.approveBtn').addClass("hidden");
            $('.approveMessage').addClass("hidden");
        }
    });
});


$(document).ready(function () {
    $(".costumer-select").select2({
        ajax: {
            url: booking_json_url + "?group=name",
            dataType: 'json',
            delay: 250,
            data: function (params) {
                return {
                    q: params.term // search term
                };
            },
            processResults: function (data, params) {
                var resData = [];
                data.forEach(function (value) {
                    if (value.title.indexOf(params.term) != -1)
                        resData.push(value)
                })
                return {
                    results: $.map(resData, function (item) {
                        return {
                            text: item.title + ":" + item.phone + ":" + item.email,
                            id: item.id
                        }
                    })
                };
            },
            cache: false
        },
        minimumInputLength: 1
    })

    $('.costumer-select').on("select2:select", function (e) {
        var value = e.params.data.text.split(':');
        $('input[name="name"]').val(value[0]);
        $('input[name="email"]').val(value[2]);
        $('input[name="phone"]').val(value[1]);
    });
});
