<?php namespace Visiosoft\BookingModule\Booking;

use Anomaly\UsersModule\User\UserModel;
use Visiosoft\BookingModule\Booking\Contract\BookingInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingBookingEntryModel;

class BookingModel extends BookingBookingEntryModel implements BookingInterface
{
    /**
     * @param array $params
     * @param array $search_fields
     * @return array
     * Control Required Field
     */
    public function requiredFieldControl(array $params, array $search_fields)
    {
        $error = array();

        foreach ($search_fields as $field) {
            if (!isset($params[$field]) or empty($params[$field])) {
                $error[] = trans('visiosoft.module.booking::error.required_field',
                    ['field' => trans('visiosoft.module.booking::field.' . $field . '.name')]);
            }
        }
        return $error;

    }

    /**
     * @param array $params
     * @param array $search_fields
     * @return array
     * Control Required Field
     */
    public function uniqueFieldControl(array $params, array $search_fields)
    {
        $error = array();

        foreach ($search_fields as $field) {
            if ($field == 'phone') {
                $exists = UserModel::where('phone_number', $params[$field])->first();
                if (!is_null($exists)) {
                    $error[] = trans('visiosoft.module.booking::error.exist_field', [
                        'field' => trans('visiosoft.module.booking::field.' . $field . '.name')
                    ]);
                }
            } else {
                $exists = UserModel::where($field, $params[$field])->first();
                if (!is_null($exists)) {
                    $error[] = trans('visiosoft.module.booking::error.exist_field', [
                        'field' => trans('visiosoft.module.booking::field.' . $field . '.name')
                    ]);
                }
            }
        }
        return $error;

    }

    /**
     * @param $service_id
     * @param $staff_id
     * @return mixed
     * Get Old reservation With Staff and Service ID
     */
    public function getBookingDateListServiceAndStaff($service_id, $staff_id)
    {
        return $this
            ->where('services_select', $service_id)
            ->where('staff_id', $staff_id)
            ->where('activated', 1)
            ->where('status', 'active')
            ->select('id', 'booking_datetime_start', 'services_select', 'staff_id')
            ->get()->toArray();
    }

    /**
     * @param array $params
     * @return array
     * Create Booking with control
     */
    public function createBooking(array $params)
    {
        //Create Save Parameters
        $saveParams['total_price'] = $params['total_price'];
        $saveParams['name'] = $params['username'];
        $saveParams['phone'] = $params['phone'];
        $saveParams['email'] = $params['email'];
        $saveParams['user_id'] = $params['user_id'];
        $saveParams['services_select'] = $params['service_id'];
        $saveParams['staff_id'] = $params['staff_id'];
        $saveParams['booking_datetime_start'] = $params['select_time'];
        $saveParams['booking_datetime_end'] = $params['booking_datetime_end'];
        $saveParams['payment_type'] = $params['payment_type'];
        $saveParams['activation_code'] = $params['activation_code'];

        //Create Booking is Save Parameters
        $booking = $this->create($saveParams);
        return $booking->id;
    }

    /**
     * @param $date
     * @param $staff_id
     * @param $service_id
     * @return mixed
     * Control is Bookingwith Date
     */
    public function isBooking($date, $staff_id, $service_id)
    {
        $search = $this
            ->where('staff_id', $staff_id)
            ->where('services_select', $service_id)
            ->where('booking_datetime_start', 'LIKE', "%$date%")
            ->first();

        if ($search != null and $search->activated == 0 and $search->status == 'pending') {
            $search->forceDelete();
            return null;
        }
        return $search;
    }

    public function activate($activation_code, $id)
    {
        $search = $this
            ->where('id', $id)
            ->where('activation_code', $activation_code)
            ->first();

        if ($search != null) {
            $search->update(['activated' => 1, 'status' => 'active']);
            return true;
        }
        return false;
    }

    public function activatePayPal($id, $payment)
    {
        $search = $this
            ->where('id', $id)
            ->first();

        if ($search != null) {
            if ($payment == "true") {
                $search->update(['activated' => 1, 'status' => 'active', 'payment_status' => "success"]);
            } else {
                $search->update(['activated' => 0, 'status' => 'pending', 'payment_status' => "failed"]);
            }
            return true;
        }
        return false;
    }

    /**
     * Disable timestamps for this model.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The number of minutes to cache query results.
     *
     * @var null|false|int
     */
    protected $ttl = false;

    /**
     * The attributes that are
     * not mass assignable.
     *
     * @var array
     */
    protected $guarded = [];

    /**
     * Runtime cache.
     *
     * @var array
     */
    protected $cache = [];

    /**
     * @param $id
     * @return mixed
     */
    public function getDetail($id)
    {
        return $this->find($id);
    }

}
