<?php namespace Visiosoft\BookingModule;

use Anomaly\Streams\Platform\Addon\Module\Module;

class BookingModule extends Module
{

    /**
     * The navigation display flag.
     *
     * @var bool
     */
    protected $navigation = true;

    /**
     * The addon icon.
     *
     * @var string
     */
    protected $icon = 'fa fa-calendar';

    /**
     * The module sections.
     *
     * @var array
     */
    protected $sections = [
        'locations' => [
            'buttons' => [
                'new_location',
            ],
        ],
        'services' => [
            'buttons' => [
                'new_service',
            ],
        ],
        'staff' => [
            'buttons' => [
                'new_staff',
            ],
        ],
        'booking' => [
            'href' => '/admin/booking/booking',
        ],
        'holidays' => [
            'buttons' => [
                'new_holiday',
            ],
        ],
    ];

}
