<?php namespace Visiosoft\BookingModule\Staff;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use Visiosoft\BookingModule\Staff\Contract\StaffInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingStaffEntryModel;

class StaffModel extends BookingStaffEntryModel implements StaffInterface
{
    public function getStaff($id = null)
    {
        if ($id == null) return $this->get();
        return $this->find($id);
    }

    public function addFotoStaff(array $items)
    {
        foreach ($items as $key => $item) {
            $items[$key]['photo_url'] = $this->getPhoto($item['id']);
        }
        return $items;
    }

    public function getPhoto($staff_id)
    {
        $staff = $this->find($staff_id)->photo;
        if ($staff != null) {
            return url('files/images/' . $this->find($staff_id)->photo->name);
        }
        return $this->dispatch(new MakeImageInstance('visiosoft.module.booking::img/no-profile.png', 'img'))->url();
    }

    public function getServiceStaff($service_id)
    {
        return $this->whereRaw('services REGEXP \'.*;s:[0-9]+:"' . $service_id . '".*\'')->get();
    }

}
