<?php namespace Visiosoft\BookingModule\Seed;

use Anomaly\Streams\Platform\Assignment\AssignmentModelTranslation;
use Anomaly\Streams\Platform\Assignment\Contract\AssignmentRepositoryInterface;
use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Anomaly\Streams\Platform\Field\Contract\FieldRepositoryInterface;
use Anomaly\Streams\Platform\Field\FieldModelTranslation;
use Anomaly\Streams\Platform\Stream\Contract\StreamRepositoryInterface;

class UsersFieldsSeeder extends Seeder
{
    private $fieldRepository;
    private $assignmentRepository;
    private $streamRepository;
    private $fieldModelTranslation;
    private $assignmentModelTranslation;

    public function __construct(
        FieldRepositoryInterface $fieldRepository,
        AssignmentRepositoryInterface $assignmentRepository,
        StreamRepositoryInterface $streamRepository,
        FieldModelTranslation $fieldModelTranslation,
        AssignmentModelTranslation $assignmentModelTranslation
    )
    {
        parent::__construct();

        $this->fieldRepository = $fieldRepository;
        $this->assignmentRepository = $assignmentRepository;
        $this->streamRepository = $streamRepository;
        $this->fieldModelTranslation = $fieldModelTranslation;
        $this->assignmentModelTranslation = $assignmentModelTranslation;
    }

    public function run()
    {
        $namespace = 'users';
        $locked = 0;
        $stream = $this->streamRepository->findBy('slug', 'users');

        $fields = $this->fieldRepository
            ->newQuery()
            ->where('slug', 'phone_number')
            ->where('namespace', $namespace)
            ->get();

        if ($fields) {
            foreach ($fields as $field) {
                $this->fieldModelTranslation->newQuery()->where('field_id', $field->id)->delete();

                $assignment = $this->assignmentRepository
                    ->newQuery()
                    ->where('stream_id', $stream->id)
                    ->where('field_id', $field->id)
                    ->first();
                if ($assignment) {
                    $this->assignmentModelTranslation->newQuery()->where('assignment_id', $assignment->id)->delete();
                    $assignment->delete();
                }

                $field->delete();
            }
        }

        $data = [
            'name' => 'Phone Number',
            'namespace' => $namespace,
            'slug' => 'phone_number',
            'type' => 'anomaly.field_type.text',
            'locked' => $locked
        ];

        $field = $this->fieldRepository->create($data);

        $this->assignmentRepository->create([
            'stream_id' => $stream->id,
            'field_id' => $field->id
        ]);
    }
}
