<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBookingCreateBookingStream extends Migration
{

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'booking',
        'title_column' => 'id',
        'translatable' => false,
        'versionable' => false,
        'trashable' => true,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'services_select' => [
            'required' => true,
        ],
        'staff',
        'user',
        'phone' => [
            'required' => true,
        ],
        'email' => [
            'required' => true,
        ],
        'name' => [
            'required' => true,
        ],
        'total_price' => [
            'required' => true,
        ],
        'booking_datetime_start' => [
            'required' => true,
        ],
        'booking_datetime_end' => [
            'required' => true,
        ],
        'payment_type' => [
            'required' => true,
        ],
        'payment_status' => [],
        'status' => [],
        'activation_code',
        'activated',
        'remindingTomorrow'
    ];

}
