$(document).ready(function () {
    $('#booking-form').on("submit", function (e) {
        e.preventDefault();

        $('.booking-alert-container').removeClass('booking-alert-container-active');

        const form = $(this);

        form.find('button').attr('disabled',true);

        $.ajax({
            type: "POST",
            url: 'ajax/validate-booking',
            data: form.serialize(),
            success: function(data) {
                if (data.errors.length) {
                    let errorsHtml = '';
                    $.each(data.errors, function (index, error) {
                        errorsHtml += `
                            <div class="booking-alert">
                                <span class="booking-alert-message">${error}</span>
                                <span class="booking-alert-closebtn" onclick="this.parentElement.style.display='none';">
                                    &times;
                                </span>
                            </div>
                        `
                    });
                    $('.booking-alert-container').html(errorsHtml).addClass('booking-alert-container-active')
                    form.find('button').attr('disabled',false);
                } else {
                    form.off('submit');
                    form.submit();
                }
            }
        });
    });
});