<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBookingCreateHolidaysStream extends Migration
{

    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * The stream definition.
     *
     * @var array
     */
    protected $stream = [
        'slug' => 'holidays',
        'title_column' => 'id',
        'translatable' => true,
        'versionable' => false,
        'trashable' => false,
        'searchable' => false,
        'sortable' => false,
    ];

    /**
     * The stream assignments.
     *
     * @var array
     */
    protected $assignments = [
        'name' => [
            'translatable' => true,
            'required' => true,
        ],
        'date' => [
            'unique' => true,
            'required' => true,
        ],
    ];

}
