<?php namespace Visiosoft\BookingModule\Holiday\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;

class HolidayTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [
        'name',
        'date' => [
            'value' => '{{ entry.date|date("m/d/Y") }}'
        ],
        'finish_date' => [
            'value' => '{{ entry.finish_date|date("m/d/Y") }}'
        ],
        'staff'
    ];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [
    ];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
