<?php namespace Visiosoft\BookingModule\Booking\Events;

use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Staff\StaffModel;

class CancellationBooking
{
    public $bookingId;

    /**
     * CancellationBooking constructor.
     * @param $booking
     */
    public function __construct($booking)
    {
        $this->booking = $booking;
    }

    public function detail()
    {
        return $this->booking;
    }

    public function location()
    {
        $serviceModel = new ServiceModel();
        $locationModel = new LocationModel();

        $service = $serviceModel->getServices($this->detail()->services_select);
        $location = $locationModel->getLocations($service->location_id);
        return $location;
    }

    public function service()
    {
        //Get Service Detail
        $service_model = new ServiceModel();
        $service = $service_model->getServices($this->detail()->services_select);
        return $service;
    }

    public function staff()
    {
        //Get Staff Detail
        $staff_model = new StaffModel();
        $staff = $staff_model->getStaff($this->detail()->staff_id);
        return $staff;
    }
}
