<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBookingAddDateRangeToHoliday extends Migration
{
    /**
     * This migration creates the stream.
     * It should be deleted on rollback.
     *
     * @var bool
     */
    protected $delete = true;

    /**
     * @var array
     */
    protected $stream = [
        'slug' => 'holidays',
    ];


    /**
     * The addon fields.
     *
     * @var array
     */
    protected $fields = [
        'finish_date' => [
            'type' => 'anomaly.field_type.datetime',
            "config" => [
                "default_value" => "now",
                "mode"          => "date",
                "date_format"   => "j F, Y",
                "picker"        => true,
            ]
        ],
    ];

    /**
     * @var array
     */
    protected $assignments = [
        'finish_date' => [
            'required' => true,
        ]
    ];


}
