<?php namespace Visiosoft\BookingModule\Booking\Table;

use Anomaly\Streams\Platform\Ui\Table\Component\View\ViewCollection;
use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Anomaly\UsersModule\User\Command\GetUser;
use Visiosoft\BookingModule\Booking\Table\Component\View\Type\Calendar;
use Visiosoft\BookingModule\Booking\Table\Component\View\Type\Table;

class BookingTableBuilder extends TableBuilder
{

    /**
     * The table actions.
     *
     * @var array
     */

    protected $actions = [
        'delete'
    ];

    /**
     * The views configuration.
     *
     * @var array|string
     */
    protected $views = [
        'booking' => [
            'view' => Calendar::class
        ],
        'table' => [
            'view' => Table::class
        ]
    ];

    /**
     * Build the table.
     *
     * @return $this
     */
    public function build()
    {

        $options = $this->table->getOptions();
        $views = new ViewCollection();

        /* create view collection */
        foreach ($this->views as $key => $item) {
            $views->put($key, app($item['view']));
        }

        $current = app('Illuminate\Http\Request')->get($options->get('prefix') . 'view');

        /* select calendar if nothing is provided */
        if ($view = $views->findBySlug($current?:'booking')) {
            $this->assets = $view->assets;
            $this->options = $view->options;
        }

        return parent::build();
    }

    /**
     * Get the table entries,
     * Filter on partner if the current user role is coordinator
     *
     * @return Collection
     */
    public function getTableEntries()
    {
        $date = date('Y-m-d');
        $user = $this->dispatch(new GetUser(null));
        $entries = $this->table->getEntries();

//        $entries = $entries->filter(function ($value, $key) use ($user) {
//            return $value->created_by_id === $user->id;
//        });
        if (!$user->isAdmin()) {
            $entries = $entries->filter(function ($value, $key) use ($date) {
                return $value->booking_datetime_start >= $date;
            });
        }

        return $entries;
    }

    protected $filters = [
    ];

}
