<?php namespace Visiosoft\BookingModule\Holiday\FormLunchBreak;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Carbon\Carbon;
use Visiosoft\BookingModule\Holiday\HolidayModel;

class LunchBreakFormHandler
{
    public function handle(LunchBreakFormBuilder $builder)
    {
        if (!$builder->canSave()) {
            return;
        }

        $date = $builder->getPostValue('date');
        $start = $builder->getPostValue('start_time');
        $finish = $builder->getPostValue('finish_time');
        $staff = $builder->getPostValue('staff');

        app($builder->getModel())->newQuery()
            ->create([
                'staff_id' => $staff,
                'date' => Carbon::make($date.' '.$start,'YYYY-MM-DD H:i'),
                'finish_date' => Carbon::make($date.' '.$finish,'YYYY-MM-DD H:i'),
                'name'=> 'lunch-break'
            ]);
    }
}
