<?php namespace Visiosoft\BookingModule\Http\Controller\Admin;

use Visiosoft\BookingModule\Location\Form\LocationFormBuilder;
use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\BookingModule\Location\Table\LocationTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class LocationsController extends AdminController
{
    private $module;

    public function __construct(LocationModel $locationModel)
    {
        parent::__construct();
        $this->module = $locationModel;
    }

    /**
     * Display an index of existing entries.
     *
     * @param LocationTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(LocationTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param LocationFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(LocationFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param LocationFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(LocationFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @return mixed
     * Location Model
     * Get Location Function
     */
    public function getLocations()
    {
        return $this->module->getLocations();
    }
}
