<?php namespace Visiosoft\BookingModule\Booking\Contract;

use Anomaly\Streams\Platform\Entry\Contract\EntryRepositoryInterface;

interface BookingRepositoryInterface extends EntryRepositoryInterface
{

    /**
     * Truncate event.
     *
     * @return static
     */
    public function truncate();

    /**
     * Create a new event.
     *
     * @param array $attributes
     * @return static
     */
    public function create(array $attributes);

    /**
     * @param $id
     * @param $status
     * @return mixed
     */
    public function changePaymentStatus($id, $status);

    public function isBookingForDate($email, $booking_date);

}
