<?php namespace Visiosoft\BookingModule\Location;

use Visiosoft\BookingModule\Location\Contract\LocationInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingLocationsEntryModel;

class LocationModel extends BookingLocationsEntryModel implements LocationInterface
{
    public function addOpenedDay($location_id)
    {
        $location['Days'] = $this->getOpenDays($location_id);
        return $location;
    }

    public function getLocations($id = null)
    {
        if($id == null) return $this->get();
        return $this->find($id);
    }

    public function getOpenDays($id)
    {
        $location = $this->getLocations($id)->toArray();
        $location = $this->removeCloseDay($location);

        $location = $this->addDayArray('monday', $location);
        $location = $this->addDayArray('tuesday', $location);
        $location = $this->addDayArray('wednesday', $location);
        $location = $this->addDayArray('thursday', $location);
        $location = $this->addDayArray('friday', $location);
        $location = $this->addDayArray('saturday', $location);
        $location = $this->addDayArray('sunday', $location);

        return $location;
    }

    public function removeCloseDay(array $location)
    {
        $key = array_search('00:00:00', $location);
        if ($key === false) {
            return $location;
        } else {
            $location[$key];
            unset($location[$key]);
            return $this->removeCloseDay($location);
        }
    }

    public function addDayArray($day, array $location)
    {
        $location['closeDays'] = array();
        $dayName = ucfirst(substr($day, 0, 3));
        if (isset($location[$day . 'Start']) and isset($location[$day . 'End'])) {
            $location[$dayName]['start'] = $location[$day . 'Start'];
            $location[$dayName]['end'] = $location[$day . 'End'];
            unset($location[$day . 'Start']);
            unset($location[$day . 'End']);
        } else {
            array_push($location['closeDays'],$dayName);
        }
        return $location;
    }

    public function getName()
    {
        return $this->name;
    }

}
