<?php namespace Visiosoft\BookingModule\Holiday\FormLunchBreak;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;
use Visiosoft\BookingModule\Holiday\HolidayModel;

class LunchBreakFormBuilder extends FormBuilder
{

    protected $model = HolidayModel::class;

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'staff' => [
            'required' => true,
        ],
        'date' => [
            'type' => 'anomaly.field_type.datetime',
            'required' => true,
            "config" => [
                "mode"          => "date",
                "date_format"   => "j F, Y",
                "picker"        => true,
            ]
        ],
        'start_time' => [
            'label' => 'visiosoft.module.booking::field.start_time.name',
            'type' => 'anomaly.field_type.datetime',
            'required' => true,
            "config" => [
                "mode"          => "time",
                "date_format"   => "H:i:sa",
            ]
        ],
        'finish_time' => [
            'label' => 'visiosoft.module.booking::field.finish_time.name',
            'type' => 'anomaly.field_type.datetime',
            'required' => true,
            "config" => [
                "mode"          => "time",
                "date_format"   => "H:i:sa",
            ]
        ],
    ];

    protected $buttons = [
        'cancel',
    ];

    protected $options = [
        'redirect' => '/admin/booking/holidays'
    ];
}
