<?php namespace Visiosoft\BookingModule\Holiday\Form;

use Anomaly\Streams\Platform\Ui\Form\FormBuilder;

class HolidayFormBuilder extends FormBuilder
{

    /**
     * The form fields.
     *
     * @var array|string
     */
    protected $fields = [
        'name',
        'date' => [
            'type' => 'anomaly.field_type.datetime',
            "config" => [
                "mode"          => "date",
                "date_format"   => "j F, Y",
                "picker"        => true,
            ]
        ],
        'finish_date' => [
            'type' => 'anomaly.field_type.datetime',
            "config" => [
                "mode"          => "date",
                "date_format"   => "j F, Y",
                "picker"        => true,
            ]
        ],
    ];

    /**
     * Additional validation rules.
     *
     * @var array|string
     */
    protected $rules = [];

    /**
     * Fields to skip.
     *
     * @var array|string
     */
    protected $skips = [];

    /**
     * The form actions.
     *
     * @var array|string
     */
    protected $actions = [];

    /**
     * The form buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'cancel',
    ];

    /**
     * The form options.
     *
     * @var array
     */
    protected $options = [
        'redirect' => '/admin/booking/holidays'
    ];

    /**
     * The form sections.
     *
     * @var array
     */
    protected $sections = [];

    /**
     * The form assets.
     *
     * @var array
     */
    protected $assets = [
        'scripts.js' => [
            'visiosoft.module.booking::js/admin/holidayDateChecker.js',
        ],
    ];

}
