<?php namespace Visiosoft\BookingModule\Booking\Table;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Visiosoft\BookingModule\Booking\Table\Filter\LocationFilterQuery;
use Visiosoft\BookingModule\Location\Contract\LocationRepositoryInterface;

/**
 * Class BookingTableFilters
 *
 * @author Dia Shalabi <dia@visiosoft.com.tr>
 */
class BookingTableFilters
{

    use DispatchesJobs;

    /**
     * Handle the filters.
     *
     * @param BookingTableBuilder $builder
     * @param LocationRepositoryInterface $locationRepository
     */
    public function handle(
        BookingTableBuilder $builder,
        LocationRepositoryInterface $locationRepository
    ) {
        $locationOptions = $locationRepository->all()->pluck('name', 'id')->all();

        $builder->setFilters(
                [
                    'staff',
                    'location' => [
                        'filter'  => 'select',
                        'query'   => LocationFilterQuery::class,
                        'options' => $locationOptions,
                    ],
                ]
            );
    }
}
