<?php namespace Visiosoft\BookingModule;

use Anomaly\Streams\Platform\Addon\AddonCollection;
use Anomaly\Streams\Platform\Addon\AddonServiceProvider;
use Maatwebsite\Excel\ExcelServiceProvider;
use Visiosoft\BookingModule\Booking\Book\BookFormBuilder;
use Visiosoft\BookingModule\Holiday\Contract\HolidayRepositoryInterface;
use Visiosoft\BookingModule\Holiday\HolidayRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingHolidaysEntryModel;
use Visiosoft\BookingModule\Holiday\HolidayModel;
use Visiosoft\BookingModule\Booking\Contract\BookingRepositoryInterface;
use Visiosoft\BookingModule\Booking\BookingRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingBookingEntryModel;
use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Booking\Listener\ActivateBooking;
use Visiosoft\BookingModule\Location\LocationPlugin;
use Visiosoft\BookingModule\Service\ServicePlugin;
use Visiosoft\BookingModule\Staff\Contract\StaffRepositoryInterface;
use Visiosoft\BookingModule\Staff\StaffPlugin;
use Visiosoft\BookingModule\Staff\StaffRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingStaffEntryModel;
use Visiosoft\BookingModule\Staff\StaffModel;
use Visiosoft\BookingModule\Service\Contract\ServiceRepositoryInterface;
use Visiosoft\BookingModule\Service\ServiceRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingServicesEntryModel;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Location\Contract\LocationRepositoryInterface;
use Visiosoft\BookingModule\Location\LocationRepository;
use Anomaly\Streams\Platform\Model\Booking\BookingLocationsEntryModel;
use Visiosoft\BookingModule\Location\LocationModel;
use Visiosoft\PaypalModule\Events\StatusItem;

class BookingModuleServiceProvider extends AddonServiceProvider
{
    protected $plugins = [
        StaffPlugin::class,
        ServicePlugin::class,
        LocationPlugin::class,
    ];

    protected $routes = [
        'admin/booking/holidays' => 'Visiosoft\BookingModule\Http\Controller\Admin\HolidaysController@index',
        'admin/booking/holidays/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\HolidaysController@create',
        'admin/booking/holidays/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\HolidaysController@edit',
        'booking/completed' =>
            [
                'as' => 'booking::action',
                'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@booking',
            ],
        'booking/activated' =>
            [
                'as' => 'booking::activated',
                'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@activateBooking',
            ],
        'booking/detail/{id}' => 'Visiosoft\BookingModule\Http\Controller\BookingController@detail',
        'booking/cancel' => [
            'as' => 'booking::cancel',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@cancelBooking',
        ],
        'booking' => [
            'as' => 'booking::create',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\BookingController@index',
        ],
        'my-profile' => 'Visiosoft\BookingModule\Http\Controller\ProfileController@index',
        'my-profile/update' => [
            'as' => 'profile::update',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\ProfileController@update'
        ],
        'srv/location' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvLocation',
        'srv/service' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvService',
        'srv/staff' => 'Visiosoft\BookingModule\Http\Controller\BookingController@srvStaff',

        'admin/booking' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@index',
        'admin/booking/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@create',
        'admin/booking/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@edit',

        'admin/booking/getDetail/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@getDetails',


        'admin/booking/staff' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@index',
        'admin/booking/staff/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@create',
        'admin/booking/staff/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@edit',
        'admin/booking/services' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@index',
        'admin/booking/services/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@create',
        'admin/booking/services/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@edit',

        'admin/booking/locations' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@index',
        'admin/booking/locations/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@create',
        'admin/booking/locations/edit/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@edit',

        //Ajax Services
        'admin/booking/ajax/locations' => 'Visiosoft\BookingModule\Http\Controller\Admin\LocationsController@getLocations',
        'admin/booking/ajax/services/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@getServices',
        'admin/booking/ajax/find-services/{column},{value}' => 'Visiosoft\BookingModule\Http\Controller\Admin\ServicesController@findService',
        'admin/booking/ajax/staff/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\StaffController@getStaff',
        'admin/booking/ajax/create' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@createAjax',
        'admin/booking/ajax/edit' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@editAjax',
        'admin/booking/ajax/approve/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@approveAjax',
        'admin/booking/ajax/delete/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@deleteAjax',

        // Forgot password
        'users/password/forgot/done' => 'Visiosoft\BookingModule\Http\Controller\BookingController@forgotPasswordMailSent',
        'users/password/reset/done' => 'Visiosoft\BookingModule\Http\Controller\BookingController@passwordResetConfirmation',

        //AJAX
        'ajax/getService/{id}' => 'Visiosoft\BookingModule\Http\Controller\BookingController@ajaxGetService',
        'ajax/validate-booking' => 'Visiosoft\BookingModule\Http\Controller\BookingController@validateBooking',
        'admin/bookingJSON' => [
            'as' => 'visiosoft.module.booking::admin_booking_json',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@bookingJSON',
        ],
        'admin/bookingWithUserJSON' => [
            'as' => 'visiosoft.module.booking::admin_booking_with_user_json',
            'uses' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@bookingWithUserJSON',
        ],
        'admin/staffJSON' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@staffJSON',
        'admin/booking/approvePayment/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@ApprovePayment',
        'admin/booking/ajax/approvePayment/{id}' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@ApprovePaymentAjax',
        'cron/remindingCron' => 'Visiosoft\BookingModule\Http\Controller\BookingController@remindingCron',

        'admin/booking/export-excel' => 'Visiosoft\BookingModule\Http\Controller\Admin\BookingController@exportExcel',
    ];

    protected $listeners = [
        StatusItem::class => [
            ActivateBooking::class,
        ]
    ];

    protected $bindings = [
        BookingHolidaysEntryModel::class => HolidayModel::class,
        BookingBookingEntryModel::class => BookingModel::class,
        BookingStaffEntryModel::class => StaffModel::class,
        BookingServicesEntryModel::class => ServiceModel::class,
        BookingLocationsEntryModel::class => LocationModel::class,
        'book' => BookFormBuilder::class,
    ];

    protected $singletons = [
        HolidayRepositoryInterface::class => HolidayRepository::class,
        BookingRepositoryInterface::class => BookingRepository::class,
        StaffRepositoryInterface::class => StaffRepository::class,
        ServiceRepositoryInterface::class => ServiceRepository::class,
        LocationRepositoryInterface::class => LocationRepository::class,
    ];

    public function getOverrides()
    {
        $request = app('Illuminate\Http\Request');
        $view = $request->get('view');

        if ($request->segment(2) === $this->addon->getSlug() && $view === 'booking' and $request->path() == "admin/booking") {
            return [
                'streams::table/partials/header' => 'visiosoft.module.booking::admin/table/partials/header',
                'streams::table/partials/body' => 'visiosoft.module.booking::admin/table/partials/body',
                'streams::table/table' => 'visiosoft.module.booking::admin/table/table'
            ];
        }

        return parent::getOverrides();
    }

    protected $providers = [
        ExcelServiceProvider::class
    ];

}
