<?php namespace Visiosoft\BookingModule\Service\Form;

class ServiceFormFields
{
    public function handle(ServiceFormBuilder $builder)
    {
        $builder->setFields([
            'photo',
            'name',
            'description',
            'time',
            'price',
            'location',
            'color' => [
                'value' => function () use ($builder) {
                    $rand = "#" . substr(str_shuffle('ABCDEF1234567890'), 0, 6);
                    $value = $builder->getFormEntry()->getFieldValue('color');
                    return ($builder->getFormMode() === "create") ? $rand : $value;
                }
            ],
            'enabled',
            'gift',
        ]);
    }
}
