<?php

use Anomaly\Streams\Platform\Database\Migration\Migration;

class VisiosoftModuleBookingAddStaffHoliday extends Migration
{

    public function up()
    {
        $this->fields()
            ->findBySlugAndNamespace('date', 'booking')
            ->setAttribute('config', [
                "mode"          => "datetime",
                "picker"        => true,
            ])
            ->save();

        $this->fields()
            ->findBySlugAndNamespace('finish_date', 'booking')
            ->setAttribute('config', [
                "mode"          => "datetime",
                "picker"        => true,
            ])
            ->save();

        //Remove unique Date
        $field = $this->fields()->findBySlugAndNamespace('date', 'booking');
        $stream = $this->streams()->findBySlugAndNamespace('holidays', 'booking');

        if ($field and $stream) {
            $this->assignments()->findByStreamAndField($stream, $field)->setAttribute('unique', false)->save();
        }
    }

    protected $stream = [
        'slug' => 'holidays',
    ];

    protected $fields = [
        'staff' => [
            'type' => 'anomaly.field_type.relationship',
            "config" => [
                "related"          => \Visiosoft\BookingModule\Staff\StaffModel::class,
                "mode" => 'lookup'
            ]
        ],
    ];

    protected $assignments = [
        'staff'
    ];
}
