<?php namespace Visiosoft\BookingModule\Location\Table;

use Anomaly\Streams\Platform\Ui\Table\TableBuilder;
use Visiosoft\BookingModule\Booking\Table\Component\View\Type\Trash;
use Visiosoft\BookingModule\Staff\Table\View\Table;

class LocationTableBuilder extends TableBuilder
{

    /**
     * The table views.
     *
     * @var array|string
     */
    protected $views = [
        'table' => [
            'view' => Table::class
        ],
        'trash' => [
            'view' => Trash::class,
            'icon' => 'fa fa-trash',
            'text' => 'streams::view.trash'
        ],
    ];

    /**
     * The table filters.
     *
     * @var array|string
     */
    protected $filters = [];

    /**
     * The table columns.
     *
     * @var array|string
     */
    protected $columns = [];

    /**
     * The table buttons.
     *
     * @var array|string
     */
    protected $buttons = [
        'edit'
    ];

    /**
     * The table actions.
     *
     * @var array|string
     */
    protected $actions = [
        'delete'
    ];

    /**
     * The table options.
     *
     * @var array
     */
    protected $options = [];

    /**
     * The table assets.
     *
     * @var array
     */
    protected $assets = [];

}
