<?php namespace Visiosoft\BookingModule\Rules;

use Anomaly\Streams\Platform\Message\MessageBag;
use ReCaptcha\ReCaptcha;

class ReCaptchaRule
{
    private $message;

    public function __construct(MessageBag $message)
    {
        $this->message = $message;
    }

    public function handle($attribute, $value)
    {
        if (empty($value)) {
            $this->message->error(trans('visiosoft.module.booking::messages.recaptcha_field_is_required'));

            return false;
        }

        $recaptcha = new ReCaptcha(setting_value('visiosoft.module.booking::google_captcha_secret_key'));

        $resp = $recaptcha->setExpectedHostname(request()->server('SERVER_NAME'))
            ->setScoreThreshold(setting_value('visiosoft.module.booking::score_threshold'))
            ->verify($value, request()->server('REMOTE_ADDR'));

        if (!$resp->isSuccess()) {
            $this->message->error('visiosoft.module.booking::messages.failed_to_validate_captcha');

            return false;
        }

        return true;
    }
}
