<?php namespace Visiosoft\BookingModule\Http\Controller\Admin;

use Visiosoft\BookingModule\Service\Form\ServiceFormBuilder;
use Visiosoft\BookingModule\Service\ServiceModel;
use Visiosoft\BookingModule\Service\Table\ServiceTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;

class ServicesController extends AdminController
{
    private $model;

    public function __construct(ServiceModel $serviceModel)
    {
        parent::__construct();
        $this->model = $serviceModel;

    }

    /**
     * Display an index of existing entries.
     *
     * @param ServiceTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(ServiceTableBuilder $table)
    {
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param ServiceFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(ServiceFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param ServiceFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(ServiceFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @return mixed
     * Service Model
     * Get Service Function
     */
    public function getServices($id)
    {
        return $this->model->findLocationServices($id);
    }

    /**
     * @return mixed
     * Service Model
     * Find Service Param Function
     */
    public function findService($column, $value)
    {
        return $this->model->findServiceParam($column, $value);
    }
}
