<?php namespace Visiosoft\BookingModule\Booking\Table\Component\View\Type;

use Anomaly\Streams\Platform\Message\MessageBag;
use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;


class Table extends View
{


    protected $slug = 'table';


    protected $text = 'visiosoft.module.booking::view.table';


    protected $icon = 'fa fa-list-ul';


    protected $columns = [
        'staff',
        'booking_datetime_start',
        'name',
        'phone',
        'email',
        'service' => [
            'heading' => 'visiosoft.module.booking::field.services_select.name',
            'value' =>
                '{{ findService(entry.services_select).name }} '
        ],
        'services_select' => [
            'heading' => 'visiosoft.module.booking::field.gift.name',
            'value' =>
                '{% if findService(entry.services_select).gift == true %} ' .
                '<i  class="fa fa-check text-success"></i>' .
                ' {% endif %}',
        ],
        'payment_type',
        'payment_status' => [
            'value' => "{% if entry.payment_status == 'waiting' %}"
                . "<i class='fa fa-clock-o'></i>" .
                " <a class='text-primary' href='/admin/booking/approvePayment/{entry.id}'>{{ trans('visiosoft.module.booking::button.approve') }}</a>" .
                "{% elseif entry.payment_status == 'failed' %}" .
                "<i class='fa fa-times text-danger'></i>" .
                "{% elseif entry.payment_status == 'success' %}" .
                "<i class='fa fa-check text-success'></i>" .
                "{% endif %}",
        ]
    ];


    protected $buttons = [
        'edit'
    ];


    public $assets = [];


    public $options = [
        'order_by' => [
            'id' => 'DESC'
        ]
    ];


    protected $query = AllQuery::class;

}
