<?php namespace Visiosoft\BookingModule\Notifications;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Support\Str;
use Visiosoft\NotificationsModule\Template\Command\CreateTemplate;
use Visiosoft\NotificationsModule\Template\Contract\TemplateRepositoryInterface;


class BookingModuleNotificationsTemplateSeeder extends Seeder
{
    use DispatchesJobs;
    public function run()
    {
        if (is_module_installed('visiosoft.module.notifications')) {

            $templates = [
                [
                    'en' => [
                        'message' => '<p><strong>You have an upcoming reservation!<br>Location:{location}<br>Service:{service}<br>Staff:{staff}<br>Date:{date}</strong></p>',
                        'name' => 'Reminding Tomorrow Booking',
                        'greeting' => 'Hi {name}',
                        'subject' => 'You have an upcoming reservation!'
                    ],
                    'stream' => 'booking',
                    'slug' => Str::slug('Reminding Tomorrow Booking', '_')
                ]
            ];

            foreach ($templates as $template) {
                $this->dispatchNow(new CreateTemplate($template));
            }
        }
    }
}