<?php namespace Visiosoft\BookingModule\Http\Controller\Admin;

use Anomaly\SettingsModule\Setting\Contract\SettingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryModel;
use PHPUnit\Util\Json;
use Visiosoft\BookingModule\Booking\BookingModel;
use Illuminate\Contracts\Config\Repository;
use Visiosoft\BookingModule\Booking\Form\BookingFormBuilder;
use Visiosoft\BookingModule\Booking\Table\BookingTableBuilder;
use Anomaly\Streams\Platform\Http\Controller\AdminController;
use Visiosoft\BookingModule\Service\ServiceModel;
use Illuminate\Http\Request;

class BookingController extends AdminController
{
    private $model;
    private $request_params;

    public function __construct(BookingModel $model, Request $request)
    {
        parent::__construct();
        $this->model = $model;
        $this->request_params = $request->all();
    }

    /**
     * Display an index of existing entries.
     *
     * @param BookingTableBuilder $table
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function index(BookingTableBuilder $table)
    {
        $table->setColumns(['staff', 'booking_datetime_start',
            'services_select' => [
                'value' => function (EntryModel $entry, SettingRepositoryInterface $setting) {
                    return $this->getServiceName($entry->services_select, $setting);
                }
            ]
            , 'name', 'phone', 'email']);
        return $table->render();
    }

    /**
     * Create a new entry.
     *
     * @param BookingFormBuilder $form
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function create(BookingFormBuilder $form)
    {
        return $form->render();
    }

    /**
     * Edit an existing entry.
     *
     * @param BookingFormBuilder $form
     * @param        $id
     * @return \Symfony\Component\HttpFoundation\Response
     */
    public function edit(BookingFormBuilder $form, $id)
    {
        return $form->render($id);
    }

    /**
     * @param $id
     * @param $setting
     * @return string
     */
    public function getServiceName($id, $setting)
    {
        $serviceModel = new ServiceModel();
        return $serviceModel->getServiceName($id) . " - " . $serviceModel->getServicePrice($id) . " " . substr($setting->value('streams::currency'), 0, 3);
    }

    /**
     * @param BookingModel $bookingModel
     * @param $id
     */
    public function getDetails(BookingModel $bookingModel, $id)
    {
        return $this->response->json($bookingModel->getDetail($id));
    }

    public function createAjax()
    {
        $params = $this->request_params;
        unset($params['locations']);
        $this->model->create($params);
        $this->messages->success('visiosoft.module.booking::message.success_create_booking');
        return response()->json(['status' => 'success']);
    }

    public function editAjax()
    {
        $params = $this->request_params;
        unset($params['locations']);
        $this->model->find($params['id'])->update($params);
        $this->messages->success('visiosoft.module.booking::message.success_edit_booking');
        return response()->json(['status' => 'success']);
    }

    public function deleteAjax($id)
    {
        $this->model->newQuery()->find($id)->forceDelete();
        $this->messages->success(trans('streams::message.delete_success', ['count' => 1]));
        return $this->redirect->to('/admin/booking/booking');
    }
}
