var start_date = null;
var end_date = null;
var refresh = true;
var refresh_time = 5000; // Millisecond
/***************************/
/***///      AJAX      ****/
/*************************/
function crudForBooking(params, url, type, callback) {
    $.ajax({
        type: type,
        data: params,
        url: url,
        success: function (response) {
            callback(response);
        },
    });
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Edit Booking   ****/
/*************************/
function bookingModal(id) {
    crudForBooking('id=' + id, '/admin/booking/getDetail/' + id, 'GET', function (response) {
        var details = response; //Detail Booking

        //Get Location ALL Locations
        getLocations(function () {

            //Get Location ID With Service ID && Select Location
            getServiceLocation(details.services_select, function (response) {
                $('select[name="locations"]').val(response.location_id);

                //Get Services With Location ID && Select Service
                getServices(response.location_id, function (e) {
                    $('select[name="services_select"]').val(details.services_select);

                    //Get Staff With Service && Select Staff
                    getStaff(details.services_select, function (e) {
                        console.log(details)
                        $('form[name="booking-modal-form"]').append('<input name="id" type="hidden" value="' + details.id + '">');
                        $('form[name="booking-modal-form"]').attr('data-type', 'edit');
                        $('select[name="staff"]').val(details.staff_id)
                        $('input[name="phone"]').val(details.phone);
                        $('input[name="email"]').val(details.email);
                        $('input[name="name"]').val(details.name);
                        $('input[name="total_price"]').val(details.total_price);
                        $('select[name="payment_type"]').val(details.payment_type);
                        if (details.status == "pending") {
                            $('.approveBtn').removeClass("hidden");
                            $('.approveMessage').removeClass("hidden");
                            $('.removeBtn').removeClass("hidden");
                            var removeBtn = $('.removeBtn');
                            var approveBtn = $('.approveBtn');
                            removeBtn.attr('href', '/admin/booking/ajax/delete/' + details.id)
                            approveBtn.attr('href', '/admin/booking/ajax/approve/' + details.id)
                        } else {
                            $('.approveBtn').addClass("hidden");
                            $('.removeBtn').addClass("hidden");
                            $('.approveMessage').addClass("hidden");
                        }
                        enable_picker(details.booking_datetime_start, details.booking_datetime_end);
                    })

                })

            });

        });

    })
    openModal();

}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Locations  ****/
/*************************/
function getLocations(callback) {
    crudForBooking('', '/admin/booking/ajax/locations', 'GET', function (response) {
        $('select[name="locations"]').html('');
        $('select[name="locations"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            $('select[name="locations"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        return callback();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Location   ****/
/***/// With Service  ****/
/************************/
function getServiceLocation(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/find-services/booking_services.id,' + service_id, 'GET',
        function (response) {
            return callback(response);
        })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Services   ****/
/*************************/
function getServices(location_id, callback) {
    crudForBooking('', '/admin/booking/ajax/services/' + location_id, 'GET', function (response) {
        $('select[name="services_select"]').html('');
        $('select[name="services_select"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            // if (index == 0) getStaff(value.id);
            $('select[name="services_select"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/***************************/
/***/// Get Staff      ****/
/*************************/
function getStaff(service_id, callback) {
    crudForBooking('', '/admin/booking/ajax/staff/' + service_id, 'GET', function (response) {
        $('select[name="staff"]').html('');
        $('select[name="staff"]').append('<option selected disabled>...</option>');
        $.each(response, function (index, value) {
            $('select[name="staff"]').append('<option value=' + value.id + '>' + value.name + '</option>');
        });
        return callback(response);
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// On Change Start ****/
/**************************/
$('select[name="locations"]').on('change', function () {
    getServices($(this).val(), function () {
    })
})

$('select[name="services_select"]').on('change', function () {
    getStaff($(this).val(), function () {
    })
})
/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***/// Create Booking  ****/
/**************************/
function addBooking(e) {
    getLocations(function () {
        enable_picker(e.attr('data-date'), e.attr('data-date'));
        $('select[name="services_select"]').html("");
        $('select[name="staff"]').html("");
        $('input[name="phone"]').val("");
        $('input[name="email"]').val("");
        $('input[name="name"]').val("");
        $('input[name="total_price"]').val("");
        $('select[name="payment_type"]').val('');
        openModal();
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Create DatePicker****/
/**************************/
function enable_picker(start, end) {
    var opt = {
        altInput: true,
        allowInput: false,
        locale: "en",
        altFormat: "j F, Y H:i",
        minuteIncrement: 1,
        dateFormat: "Y-m-d H:i",
        time_24hr: true,
        enableTime: true,
        noCalendar: false
    };
    if (start_date != null) {
        start_date.setDate(start);
    } else {
        $('input[name="booking_datetime_start"]').val(start);
        start_date = $('input[name="booking_datetime_start"]').flatpickr(opt);
    }
    if (end_date != null) {
        end_date.setDate(end);
    } else {
        $('input[name="booking_datetime_end"]').val(end)
        end_date = $('input[name="booking_datetime_end"]').flatpickr(opt);
    }
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Modal Form Submit****/
/**************************/
$('form[name="booking-modal-form"]').on("submit", function (event) {
    event.preventDefault();
    saveBooking($(this).serialize(), $('form[name="booking-modal-form"]').attr('data-type'))
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Save Booking  ****/
/**************************/
function saveBooking(params, type) {
    crudForBooking(params, '/admin/booking/ajax/' + type, 'POST', function (response) {
        if (response.status == 'success') location.href = location.href;
    })
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///   Open Modal    ****/
/**************************/
function openModal() {
    $('#bookingModal').modal('show');
    refresh = false
    console.log("Refresh Stop!")
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///  Refresh Ready  ****/
/**************************/
$(document).ready(function () {
    refreshPage(refresh_time)
});

/***********************************************************************************************************/
/**********************************************************************************************************/


/****************************/
/***///Refresh Function ****/
/**************************/
function refreshPage(time) {
    console.log("Refresh Start!")
    setTimeout(function () {
        if (refresh)
            location.reload();
    }, time);
}

/***********************************************************************************************************/
/**********************************************************************************************************/


/*****************************/
/***///Modal Close Event ****/
/***************************/
$('#bookingModal').on('hidden.bs.modal', function () {
    refresh = true
    refreshPage(refresh_time);
});

/***********************************************************************************************************/
/**********************************************************************************************************/