<?php namespace Visiosoft\BookingModule\Booking\Listener;


use Illuminate\Contracts\Events\Dispatcher;
use Visiosoft\BookingModule\Booking\BookingModel;
use Visiosoft\BookingModule\Booking\Events\CreateBooking;
use Visiosoft\PaypalModule\Events\StatusItem;
use Visiosoft\PaypalModule\Payment\PaymentModel;

class ActivateBooking
{

    private $model;
    private $BookingModel;
    private $event;

    public function __construct(PaymentModel $paymentModel, BookingModel $bookingModel,Dispatcher $events)
    {
        $this->model = $paymentModel;
        $this->BookingModel = $bookingModel;
        $this->event = $events;
    }

    public function handle(StatusItem $event)
    {
        $item = $this->model->getItemWithKey($event->key);
        if ($event->status == "true") {
            $this->BookingModel->activatePayPal($item->item_id, 'true');
            $this->event->dispatch(new CreateBooking($item->item_id));
            return "true";
        } else {
            $this->BookingModel->activatePayPal($item->item_id, 'false');
            return "false";
        }
    }
}
