<?php namespace Visiosoft\BookingModule\Staff;

use Anomaly\Streams\Platform\Image\Command\MakeImageInstance;
use DatePeriod;
use DateTime;
use function GuzzleHttp\Psr7\str;
use stdClass;
use Visiosoft\BookingModule\Staff\Contract\StaffInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingStaffEntryModel;

class StaffModel extends BookingStaffEntryModel implements StaffInterface
{
    public function getStaff($id = null)
    {
        if ($id == null) return $this->get();
        return $this->find($id);
    }

    public function addFotoStaff(array $items)
    {
        foreach ($items as $key => $item) {
            $items[$key]['photo_url'] = $this->getPhoto($item['id']);
        }
        return $items;
    }

    public function getPhoto($staff_id)
    {
        $staff = $this->find($staff_id)->photo;
        if ($staff != null) {
            return url('files/images/' . $this->find($staff_id)->photo->name);
        }
        return $this->dispatch(new MakeImageInstance('visiosoft.module.booking::img/no-profile.png', 'img'))->url();
    }

    public function getServiceStaff($service_id)
    {
        return $this->whereRaw('services REGEXP \'.*;s:[0-9]+:"' . $service_id . '".*\'')->get();
    }


    public function diffMinutes($to, $from)
    {
        $to_time = strtotime($to);
        $from_time = strtotime($from);
        return round(abs($to_time - $from_time) / 60, 2);
    }

    public function addMinutesTimes(array $closed_for_start = [], $minutes, $part, $current_time)
    {
        $q = $minutes / $part;

        if ($q > 0)
            $closed_for_start[] = $current_time;

        if ($q > 1) {
            for ($i = 1; $i < $q; $i++) {
                $time = new \DateTime($current_time);
                $time->add(new \DateInterval('PT' . $part * $i . 'M'));

                $stamp = $time->format('Y-m-d H:i:s');
                $closed_for_start[] = $stamp;
            }
        }

        return $closed_for_start;
    }

    public function getStartAndFinishJobTime($service_time, $week, $location, $staff_detail)
    {
        $closed_for_start = array();
        $times = ['end', 'start'];

        foreach ($times as $item_time) {
            $StaffWorkingWeek = array();
            foreach ($week as $key => $value) {
                $day = $value->format('l');
                $StaffWorkingWeek[substr($value->format('l'), 0, 3)] = $value->format('Y-m-d') . " " . $staff_detail[strtolower($day) . ucfirst($item_time)];
            }

            foreach ($StaffWorkingWeek as $key => $date) {
                $dayName = date("l", strtotime($date));
                if (isset($location['Days'][substr($dayName, 0, 3)])) {

                    $start = $staff_detail[strtolower($dayName) . ucfirst($item_time)];
                    $end = $location['Days'][substr($dayName, 0, 3)][$item_time];

                    $minutes = $this->diffMinutes($start, $end);
                    $diffTime = strtotime($start) - strtotime($end);
                    $time_location = date('Y-m-d', strtotime($date)) . " " . date('H:i:s', strtotime($location['Days'][substr($dayName, 0, 3)][$item_time]));

                    if ($item_time == "end") {
                        $minutes = $this->diffMinutes($end, $start);
                        $diffTime = strtotime($end) - strtotime($start);
                        $time_location = date('Y-m-d H:i:s', strtotime($date));
                    }

                    if ($diffTime > 0)
                        $closed_for_start = $this->addMinutesTimes($closed_for_start, $minutes, $service_time, $time_location);
                }
            }
        }
        return $closed_for_start;
    }

    public function getNoonStartAndFinish($week, $location, $service_time, $noonTimeList)
    {
        $StaffWorkingWeek = array();
        $closed_for_start = array();

        foreach ($week as $key => $value) {
            $day = $value->format('l');
            if (isset($noonTimeList[strtolower($day) . "EndNoon"]))
                $StaffWorkingWeek[substr($value->format('l'), 0, 3)] = $value->format('Y-m-d') . " " . $noonTimeList[strtolower($day) . "EndNoon"];
        }

        foreach ($StaffWorkingWeek as $key => $date) {
            $dayName = date("l", strtotime($date));

            $start = $noonTimeList[strtolower($dayName) . "StartNoon"];
            $end = $noonTimeList[strtolower($dayName) . "EndNoon"];

            $minutes = $this->diffMinutes($end, $start);

            $diffTime = strtotime($end) - strtotime($start);

            $time_location = date('Y-m-d', strtotime($date)) . " " . date('H:i:s', strtotime($noonTimeList[strtolower($dayName) . "StartNoon"]));

            if ($diffTime > 0)
                $closed_for_start = $this->addMinutesTimes($closed_for_start, $minutes, $service_time, $time_location);
        }
        return $closed_for_start;
    }

    public function getWeek($start_week)
    {
        $end_week = date('Y-m-d H:i:s', strtotime($start_week . ' + 7 day'));

        $week = new DatePeriod(
            new \DateTime($start_week),
            new \DateInterval('P1D'),
            new \DateTime($end_week)
        );

        return $week;
    }


    public function addJobTime(array $booking, $service_time, $staff, $location)
    {

        $staff_detail = $this->find($staff)->toArray();
        $closed_for_start = array();

        $week = $this->getWeek(date('Y-m-d H:i:s', time()));

        /* GET Start && Finisth Time */
        $startAndFinishTime = $this->getStartAndFinishJobTime($service_time, $week, $location, $staff_detail);
        /* GET Start && Finisth Time END */
//        dd(1);

        /* GET NoonStart && NoonFinish Time */
        $noonForLocation = $this->getNoonStartAndFinish($week, $location, $service_time, $location['Days']);
        $noonForStaff = $this->getNoonStartAndFinish($week, $location, $service_time, $staff_detail);
        /* GET NoonStart && NoonFinish Time END */

        $closed_for_start = array_merge($closed_for_start, $startAndFinishTime, $noonForLocation, $noonForStaff);

        foreach ($closed_for_start as $item) {
            $object = new stdClass();
            $object->booking_datetime_start = $item;
            array_push($booking, $object);
        }

        return $booking;

    }

}
