<?php namespace Visiosoft\BookingModule\Booking;

use Visiosoft\BookingModule\Booking\Contract\BookingRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class BookingRepository extends EntryRepository implements BookingRepositoryInterface
{


    protected $model;


    public function __construct(BookingModel $model)
    {
        $this->model = $model;
    }

    public function find($attributes)
    {
        if(is_array($attributes)){
            return $this->model->where($attributes)->first();
        }

        return parent::find(/* $id */ $attributes);
    }

    public function findBy($field, $value, $operation = '=')
    {
        return $this->model->where($field, $operation, $value)->first();
    }

    public function findOrNew(array $attributes)
    {
        if(is_null($model = $this->find($attributes))){
            return $this->create($attributes);
        }

        return $model;
    }
}
