<?php namespace Visiosoft\BookingModule\Service;

use Visiosoft\BookingModule\Service\Contract\ServiceInterface;
use Anomaly\Streams\Platform\Model\Booking\BookingServicesEntryModel;

class ServiceModel extends BookingServicesEntryModel implements ServiceInterface
{
    public function getServiceTime($service_id)
    {
        return $this->find($service_id)->time;
    }

    public function addServiceTime($id)
    {
        $service['service_time'] = $this->getServiceTime($id);
        $service ['location_id'] = $this->getLocationID($id);
        return $service;
    }

    public function getLocationID($id)
    {
        return $this->find($id)->location_id;
    }

    public function getServicePrice($id)
    {
        return $this->find($id)->price;
    }

    public function getServiceName($id)
    {
        return $this->find($id)->name;
    }

    public function getServices($id = null)
    {
        if ($id == null) return $this->get();
        return $this->find($id);
    }

    public function findLocationServices($location_id)
    {
        return $this->where('location_id', $location_id)->get();
    }

    public function findServiceParam($column, $value)
    {
        return $this->where($column, $value)->first();
    }


}
