$(document).ready(function () {
    if (!APP_DEBUG) {
        console = console || {};
        console.log = function () {
        };
    }

    var inputQuery = document.querySelector("input[name=\"phone\"]");
    var iti = intlTelInput(inputQuery, {
        hiddenInput: "full_phone",
        initialCountry: "auto",
        geoIpLookup: function (success, failure) {
            $.get("https://ipinfo.io", function () {
            }, "jsonp").always(function (resp) {
                var countryCode = (resp && resp.country) ? resp.country : "";
                success(countryCode);
            });
        }
    });
    var currentMask = $('input[name="phone"]').attr('placeholder');
    $('input[name="phone"]').mask(currentMask.replace(/[0-9+]/ig, '9'), {autoclear: true, clearIncomplete: true});
});

$('input[name="phone"]').on('countrychange', function (e) {
    var currentMask = $('input[name="phone"]').attr('placeholder');
    $('input[name="phone"]').mask(currentMask.replace(/[0-9+]/ig, '9'), {autoclear: true, clearIncomplete: true});
});