<?php namespace Visiosoft\BookingModule;

use Anomaly\Streams\Platform\Database\Seeder\Seeder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;
use Visiosoft\BookingModule\Notifications\BookingModuleNotificationsTemplateSeeder;
use Visiosoft\BookingModule\Seed\UsersFieldsSeeder;

class BookingModuleSeeder extends Seeder
{

    /**
     * Run the seeder.
     */
    public function run()
    {
        //Notifications Template Seeder
        $this->call(BookingModuleNotificationsTemplateSeeder::class);

        // Users Fields Seeder
        $this->call(UsersFieldsSeeder::class);

        Model::unguard();
        DB::unprepared(file_get_contents(__DIR__.'/bb.sql'));
        Model::reguard();
    }
}
