<?php namespace Visiosoft\BookingModule\Booking\Table\Component\View\Type;

use Anomaly\Streams\Platform\Ui\Table\Component\View\Query\AllQuery;
use Anomaly\Streams\Platform\Ui\Table\Component\View\View;


class Calendar extends View
{


    protected $slug = 'booking';


    protected $text = 'visiosoft.module.booking::view.calendar';


    protected $icon = 'fa fa-calendar';


    protected $columns = [
        'event' => [
            'wrapper' => '{entry.booking_datetime_start} - {entry.booking_datetime_end}'
        ],
        'booking_datetime_start',
        'booking_datetime_end'
    ];


    protected $buttons = [
        'edit' => [
            'text' => '',
            'href' => '#'
        ]
    ];


    public $assets = [
        'styles.css' => [
            'visiosoft.module.booking::less/calendar.less',
        ]
    ];

    public $options = [
        'limit' => 200,
        'class' => 'booking',
        'order_by' => [
            'booking_datetime_start' => 'ASC',
        ],

    ];


    protected $query = AllQuery::class;

}
