<?php namespace Visiosoft\BonusModule\Interest;

use Visiosoft\BonusModule\Interest\Contract\InterestRepositoryInterface;
use Anomaly\Streams\Platform\Entry\EntryRepository;

class InterestRepository extends EntryRepository implements InterestRepositoryInterface
{

    /**
     * The entry model.
     *
     * @var InterestModel
     */
    protected $model;

    /**
     * Create a new InterestRepository instance.
     *
     * @param InterestModel $model
     */
    public function __construct(InterestModel $model)
    {
        $this->model = $model;
    }

    /*
     * $month is the month number 1, 2, ..., 12
     */
    public function getInterestsBonuses($month = null)
    {
        $month = $month ?: date('n');

        return $this->newQuery()
            ->where('month', $month)
            ->where('executed', false)
            ->get();
    }

    public function revertNonCurrMonths()
    {
        $this->newQuery()
            ->where('month', '!=', date('n'))
            ->where('executed', true)
            ->update(['executed' => false]);
    }
}
