<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Listeners\Utilities\BonusCreation;
use Visiosoft\ProfileModule\Events\UserActivatedByMail;

class CreateEmailActivationBonus extends BonusCreation
{
    public function handle(UserActivatedByMail $event)
    {
        $this->createBonus(
            trans('visiosoft.module.bonus::field.mail_activation_bonus'),
            $event->user->id,
            setting_value('visiosoft.module.bonus::mail_activation_bonus')
        );
    }
}