<?php namespace Visiosoft\BonusModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\CartsModule\Cart\Command\GetCart;
use Visiosoft\CartsModule\Cart\Command\TotalCart;
use Visiosoft\OrdersModule\Order\Contract\OrderRepositoryInterface;

class BonusesController extends PublicController
{
    private $bonusRepository;
    private $orderRepository;

    public function __construct(BonusRepositoryInterface $bonusRepository, OrderRepositoryInterface $orderRepository)
    {
        parent::__construct();
        $this->bonusRepository = $bonusRepository;
        $this->orderRepository = $orderRepository;
    }

    public function index()
    {
        $myBonuses = $this->bonusRepository->getUserBonuses()->paginate(setting_value('streams::per_page'));

        return view('visiosoft.module.bonus::bonuses')->with('myBonuses', $myBonuses);
    }

    public function payWithBonus()
    {
        try {
            $cart = $this->dispatch(new GetCart());
            $this->dispatch(new TotalCart($cart));

            $userTotalBonus = $this->bonusRepository->getCurrentBonus();
            if ($userTotalBonus < $cart->total) {
                throw new \Exception('visiosoft.module.bonus::message.not_enough_bonus');
            }

            $this->bonusRepository->createBonus(
                trans('visiosoft.module.bonus::field.subtract_bonus'),
                -$cart->total
            );

            $order_id = \request()->cookie('order_id');

            $this->orderRepository->approveOrder($order_id);

            return redirect()->route('visiosoft.module.carts::payment_success', ['bonus']);
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
            return redirect()->route('visiosoft.module.carts::carts.review');
        }
    }
}
