<?php namespace Visiosoft\BonusModule\Http\Controller;

use Anomaly\Streams\Platform\Http\Controller\PublicController;
use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\BonusModule\Interest\Contract\InterestRepositoryInterface;

class InterestsController extends PublicController
{
    public function run(
        $type,
        InterestRepositoryInterface $bonusInterestRepository,
        \Visiosoft\InterestsModule\Interest\Contract\InterestRepositoryInterface $interestRepository,
        BonusRepositoryInterface $bonusRepository
    )
    {
        try {
            if ($type !== 'month' && $type !== 'interest') {
                throw new \Exception('visiosoft.module.bonus::message.invalid_url');
            }

            $month = $type === 'month' ? date('n') : null;
            $interestsBonuses = $bonusInterestRepository->getInterestsBonuses($month);

            foreach ($interestsBonuses as $interestBonus) {
                $interestsUsers = $interestRepository->findAllByCatID($interestBonus->category_id)->pluck('user_id');

                foreach ($interestsUsers as $userID) {
                    $bonusRepository->createBonus(
                        $interestBonus->name,
                        $interestBonus->bonus_to_be_added,
                        $userID
                    );
                }

                if ($month) {
                    $interestBonus->execute();
                }
            }

            if ($month) {
                $bonusInterestRepository->revertNonCurrMonths();
            }

            $this->messages->success(trans('visiosoft.module.bonus::message.interest_bonus_added'));
        } catch (\Exception $e) {
            $this->messages->error($e->getMessage());
        }

        return redirect()->route('visiosoft.module.bonus::admin_bonus_interests');
    }
}
