<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Bonus\Contract\BonusRepositoryInterface;
use Visiosoft\PackagesModule\Events\PackageApproved;
use Visiosoft\PackagesModule\User\Contract\UserRepositoryInterface;

class CreatePackageBonus
{
    private $bonusRepository;
    private $userPackageRepository;

    public function __construct(
        BonusRepositoryInterface $bonusRepository,
        UserRepositoryInterface $userPackageRepository
    )
    {
        $this->bonusRepository = $bonusRepository;
        $this->userPackageRepository = $userPackageRepository;
    }

    public function handle(PackageApproved $event)
    {
        $addedBonus = $event->userPackage->package->price
            * (setting_value('visiosoft.module.bonus::create_ad_bonus') / 100);

        $this->bonusRepository->createBonus(
            trans('visiosoft.module.bonus::field.package_creation_bonus'),
            $addedBonus,
            $event->userPackage->user_id
        );

        // Check if first package
        $userPackages = $this->userPackageRepository->getUserPackages($event->userPackage->user_id);
        if ($isFirstPackage = count($userPackages) === 1) {
            $firstPackageBonus = setting_value('visiosoft.module.bonus::first_package_bonus');

            $this->bonusRepository->createBonus(
                trans('visiosoft.module.bonus::field.first_package_creation_bonus'),
                $firstPackageBonus,
                $event->userPackage->user_id
            );
        }
    }
}