<?php namespace Visiosoft\BonusModule\Listeners;

use Visiosoft\BonusModule\Listeners\Utilities\BonusCreation;
use Visiosoft\DopingsModule\Events\DopingApproved;

class CreateDopingBonus extends BonusCreation
{
    public function handle(DopingApproved $event)
    {
        $this->createBonus(
            trans('visiosoft.module.bonus::field.doping_creation_bonus'),
            $event->doping->user_id,
            $event->doping->price * (setting_value('visiosoft.module.bonus::buy_doping_bonus') / 100)
        );
    }
}